/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Callable;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChannelProperty;
import hudson.remoting.ChunkedCommandTransport;
import hudson.remoting.ClassFilter;
import hudson.remoting.ClassicCommandTransport;
import hudson.remoting.CommandTransport;
import hudson.remoting.FlightRecorderInputStream;
import hudson.remoting.InternalCallable;
import hudson.remoting.JarCache;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.RequiredRoleCheckerWrapper;
import hudson.remoting.SocketChannelStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.remoting.CallableDecorator;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;

public class ChannelBuilder {
    private static final Logger LOGGER = Logger.getLogger(ChannelBuilder.class.getName());
    private static boolean CALLABLES_CAN_IGNORE_ROLECHECKER = Boolean.getBoolean(ChannelBuilder.class.getName() + ".allCallablesCanIgnoreRoleChecker");
    private static final Set<String> SPECIFIC_CALLABLES_CAN_IGNORE_ROLECHECKER = new HashSet<String>();
    private final String name;
    private final ExecutorService executors;
    private ClassLoader base = this.getClass().getClassLoader();
    private Channel.Mode mode = Channel.Mode.NEGOTIATE;
    private Capability capability = new Capability();
    @CheckForNull
    private OutputStream header;
    @CheckForNull
    private JarCache jarCache;
    private final List<CallableDecorator> decorators = new ArrayList<CallableDecorator>();
    private boolean arbitraryCallableAllowed = true;
    private boolean remoteClassLoadingAllowed = true;
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private ClassFilter filter = ClassFilter.DEFAULT;

    public ChannelBuilder(String name, ExecutorService executors) {
        this.name = name;
        this.executors = executors;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public ChannelBuilder withBaseLoader(ClassLoader base) {
        if (base == null) {
            base = this.getClass().getClassLoader();
        }
        this.base = base;
        return this;
    }

    public ClassLoader getBaseLoader() {
        return this.base;
    }

    public ChannelBuilder withMode(Channel.Mode mode) {
        this.mode = mode;
        return this;
    }

    public Channel.Mode getMode() {
        return this.mode;
    }

    public ChannelBuilder withCapability(Capability capability) {
        this.capability = capability;
        return this;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public ChannelBuilder withHeaderStream(@CheckForNull OutputStream header) {
        this.header = header;
        return this;
    }

    @CheckForNull
    public OutputStream getHeaderStream() {
        return this.header;
    }

    @Deprecated
    public ChannelBuilder withRestricted(boolean restricted) {
        this.withArbitraryCallableAllowed(!restricted);
        this.withRemoteClassLoadingAllowed(!restricted);
        return this;
    }

    @Deprecated
    public boolean isRestricted() {
        return !this.isArbitraryCallableAllowed() || !this.isRemoteClassLoadingAllowed();
    }

    public ChannelBuilder withArbitraryCallableAllowed(boolean b) {
        this.arbitraryCallableAllowed = b;
        return this;
    }

    public boolean isArbitraryCallableAllowed() {
        return this.arbitraryCallableAllowed;
    }

    public ChannelBuilder withRemoteClassLoadingAllowed(boolean b) {
        this.remoteClassLoadingAllowed = b;
        return this;
    }

    public boolean isRemoteClassLoadingAllowed() {
        return this.remoteClassLoadingAllowed;
    }

    public ChannelBuilder withJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
        return this;
    }

    public ChannelBuilder withJarCacheOrDefault(@CheckForNull JarCache jarCache) throws IOException {
        try {
            this.jarCache = jarCache != null ? jarCache : JarCache.getDefault();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Could not create jar cache. Running without cache.", ioe);
        }
        return this;
    }

    public ChannelBuilder withoutJarCache() {
        this.jarCache = null;
        return this;
    }

    @CheckForNull
    public JarCache getJarCache() {
        return this.jarCache;
    }

    public ChannelBuilder with(CallableDecorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public List<CallableDecorator> getDecorators() {
        return this.decorators;
    }

    public ChannelBuilder withRoles(Role ... roles) {
        return this.withRoles(Arrays.asList(roles));
    }

    public ChannelBuilder withRoles(Collection<? extends Role> actual) {
        return this.withRoleChecker(new RoleCheckerImpl(actual));
    }

    private static boolean isCallableProhibitedByRequiredRoleCheck(Callable<?, ?> callable) {
        if (CALLABLES_CAN_IGNORE_ROLECHECKER) {
            LOGGER.fine(() -> "Allowing all callables to ignore RoleChecker");
            return false;
        }
        if (callable instanceof InternalCallable) {
            LOGGER.fine(() -> "Callable " + callable.getClass().getName() + " is a remoting built-in callable allowed to bypass the role check");
            return false;
        }
        if (SPECIFIC_CALLABLES_CAN_IGNORE_ROLECHECKER.contains(callable.getClass().getName())) {
            LOGGER.fine(() -> "Callable " + callable.getClass().getName() + " is allowed through override");
            return false;
        }
        return true;
    }

    public ChannelBuilder withRoleChecker(RoleChecker checker) {
        return this.with(new CallableDecoratorImpl(checker));
    }

    public ChannelBuilder withProperty(Object key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public <T> ChannelBuilder withProperty(ChannelProperty<T> key, T value) {
        return this.withProperty((Object)key, (Object)value);
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ChannelBuilder withClassFilter(ClassFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        this.filter = filter;
        return this;
    }

    public ClassFilter getClassFilter() {
        return this.filter;
    }

    public Channel build(InputStream is, OutputStream os) throws IOException {
        return new Channel(this, this.negotiate(is, os));
    }

    public Channel build(Socket s) throws IOException {
        return this.build(new BufferedInputStream(SocketChannelStream.in(s)), new BufferedOutputStream(SocketChannelStream.out(s)));
    }

    public Channel build(SocketChannel s) throws IOException {
        return this.build(SocketChannelStream.in(s), SocketChannelStream.out(s));
    }

    public Channel build(CommandTransport transport) throws IOException {
        return new Channel(this, transport);
    }

    protected CommandTransport negotiate(InputStream is, OutputStream os) throws IOException {
        LOGGER.log(Level.FINER, "Sending capability preamble: {0}", this.capability);
        this.capability.writePreamble(os);
        Channel.Mode mode = this.getMode();
        if (mode != Channel.Mode.NEGOTIATE) {
            LOGGER.log(Level.FINER, "Sending mode preamble: {0}", (Object)mode);
            os.write(mode.preamble);
            os.flush();
        } else {
            LOGGER.log(Level.FINER, "Awaiting mode preamble...");
        }
        Channel.Mode[] modes = new Channel.Mode[]{Channel.Mode.BINARY, Channel.Mode.TEXT};
        byte[][] preambles = new byte[][]{Channel.Mode.BINARY.preamble, Channel.Mode.TEXT.preamble, Capability.PREAMBLE};
        int[] ptr = new int[3];
        Capability cap = new Capability(0L);
        while (true) {
            int ch;
            if ((ch = is.read()) == -1) {
                throw new EOFException("unexpected stream termination");
            }
            for (int i = 0; i < preambles.length; ++i) {
                byte[] preamble = preambles[i];
                if (preamble[ptr[i]] == ch) {
                    int n = i;
                    ptr[n] = ptr[n] + 1;
                    if (ptr[n] != preamble.length) continue;
                    switch (i) {
                        case 0: 
                        case 1: {
                            LOGGER.log(Level.FINER, "Received mode preamble: {0}", (Object)modes[i]);
                            if (mode == Channel.Mode.NEGOTIATE) {
                                mode = modes[i];
                                LOGGER.log(Level.FINER, "Sending agreed mode preamble: {0}", (Object)mode);
                                os.write(mode.preamble);
                                os.flush();
                            } else if (modes[i] != mode) {
                                throw new IOException("Protocol negotiation failure");
                            }
                            LOGGER.log(Level.FINE, "Channel name {0} negotiated mode {1} with capability {2}", new Object[]{this.name, mode, cap});
                            return this.makeTransport(is, os, mode, cap);
                        }
                        case 2: {
                            cap = Capability.read(is);
                            LOGGER.log(Level.FINER, "Received capability preamble: {0}", cap);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected preamble byte #" + i + ". Only " + preambles.length + " bytes are supported");
                        }
                    }
                    ptr[i] = 0;
                    continue;
                }
                ptr[i] = 0;
            }
            if (this.header == null) continue;
            this.header.write(ch);
        }
    }

    protected CommandTransport makeTransport(InputStream is, OutputStream os, Channel.Mode mode, Capability cap) throws IOException {
        FlightRecorderInputStream fis = new FlightRecorderInputStream(is);
        if (cap.supportsChunking()) {
            return new ChunkedCommandTransport(cap, mode.wrap(fis), mode.wrap(os), os);
        }
        ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(mode.wrap(os));
        oos.flush();
        return new ClassicCommandTransport(new ObjectInputStreamEx(mode.wrap(fis), this.getBaseLoader(), this.getClassFilter()), oos, fis, os, cap);
    }

    static {
        String propertyName = ChannelBuilder.class.getName() + ".specificCallablesCanIgnoreRoleChecker";
        String property = System.getProperty(propertyName);
        if (property != null) {
            Set names = Arrays.stream(property.split(",")).map(String::trim).collect(Collectors.toSet());
            LOGGER.log(Level.INFO, () -> "Allowing the following callables to bypass role checker requirement: " + String.join((CharSequence)", ", names));
            SPECIFIC_CALLABLES_CAN_IGNORE_ROLECHECKER.addAll(names);
        }
    }

    private static class RoleCheckerImpl
    extends RoleChecker {
        private final Collection<? extends Role> actual;

        public RoleCheckerImpl(Collection<? extends Role> actual) {
            this.actual = Objects.requireNonNull(actual);
        }

        @Override
        public void check(@NonNull RoleSensitive subject, @NonNull Collection<Role> expected) {
            if (!this.actual.containsAll(expected)) {
                ArrayList<Role> c = new ArrayList<Role>(expected);
                c.removeAll(this.actual);
                throw new SecurityException("Unexpected role: " + String.valueOf(c));
            }
        }
    }

    private static class CallableDecoratorImpl
    extends CallableDecorator {
        private final RoleChecker checker;

        public CallableDecoratorImpl(RoleChecker checker) {
            this.checker = Objects.requireNonNull(checker);
        }

        @Override
        public <V, T extends Throwable> Callable<V, T> userRequest(Callable<V, T> op, Callable<V, T> stem) {
            try {
                RequiredRoleCheckerWrapper wrapped = new RequiredRoleCheckerWrapper(this.checker);
                stem.checkRoles(wrapped);
                if (wrapped.isChecked()) {
                    LOGGER.log(Level.FINER, () -> "Callable " + stem.getClass().getName() + " checked roles");
                } else if (ChannelBuilder.isCallableProhibitedByRequiredRoleCheck(stem)) {
                    LOGGER.log(Level.INFO, () -> "Rejecting callable " + stem.getClass().getName() + " for ignoring RoleChecker in #checkRoles, see https://www.jenkins.io/redirect/required-role-check");
                    throw new SecurityException("Security hardening prohibits the Callable implementation " + stem.getClass().getName() + " from ignoring RoleChecker, see https://www.jenkins.io/redirect/required-role-check");
                }
            }
            catch (AbstractMethodError e) {
                this.checker.check((RoleSensitive)stem, Role.UNKNOWN);
            }
            return stem;
        }
    }
}

