/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

class SynchronousExecutorService
extends AbstractExecutorService {
    private volatile boolean shutdown = false;
    private int count = 0;

    SynchronousExecutorService() {
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.shutdown && this.count == 0;
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long now = System.nanoTime();
        long end = now + unit.toNanos(timeout);
        while (this.count != 0) {
            long d = end - now;
            if (d <= 0L) {
                return false;
            }
            this.wait(TimeUnit.NANOSECONDS.toMillis(d));
            now = System.nanoTime();
        }
        return true;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        this.touchCount(1);
        try {
            command.run();
        }
        finally {
            this.touchCount(-1);
        }
    }

    private synchronized void touchCount(int diff) {
        this.count += diff;
        if (this.count == 0) {
            this.notifyAll();
        }
    }
}

