/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.cert;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

public class DelegatingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    @NonNull
    private volatile X509ExtendedTrustManager delegate;

    public DelegatingX509ExtendedTrustManager(@NonNull X509ExtendedTrustManager delegate) {
        this.delegate = delegate;
    }

    public void setDelegate(@NonNull X509ExtendedTrustManager delegate) {
        this.delegate = delegate;
    }

    @NonNull
    public X509ExtendedTrustManager getDelegate() {
        return this.delegate;
    }

    private static void validateAuthType(String authType) {
        if (authType == null) {
            throw new IllegalArgumentException("authType must not be null");
        }
        if (authType.isEmpty()) {
            throw new IllegalArgumentException("authType must not be zero-length");
        }
    }

    private static void validateChain(X509Certificate[] chain) {
        if (chain == null) {
            throw new IllegalArgumentException("chain must not be null");
        }
        if (chain.length == 0) {
            throw new IllegalArgumentException("chain must not be zero-length");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkServerTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        DelegatingX509ExtendedTrustManager.validateAuthType(authType);
        DelegatingX509ExtendedTrustManager.validateChain(chain);
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

