/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Logger;

public class AnonymousClassWarnings {
    private static final Logger LOGGER = Logger.getLogger(AnonymousClassWarnings.class.getName());
    private static final Map<Class<?>, Boolean> checked = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(@NonNull Class<?> clazz) {
        Map<Class<?>, Boolean> map = checked;
        synchronized (map) {
            if (checked.put(clazz, true) != null) {
                return;
            }
        }
        Channel channel = Channel.current();
        if (channel == null) {
            AnonymousClassWarnings.doCheck(clazz);
        } else {
            try {
                channel.executor.submit(() -> AnonymousClassWarnings.doCheck(clazz));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static void doCheck(@NonNull Class<?> c) {
        if (!Enum.class.isAssignableFrom(c)) {
            if (c.isAnonymousClass()) {
                AnonymousClassWarnings.warn(c, "anonymous");
            } else if (c.isLocalClass()) {
                AnonymousClassWarnings.warn(c, "local");
            } else if (c.isSynthetic()) {
                AnonymousClassWarnings.warn(c, "synthetic");
            }
        }
    }

    private static void warn(@NonNull Class<?> c, String kind) {
        String name = c.getName();
        String codeSource = AnonymousClassWarnings.codeSource(c);
        if (codeSource == null) {
            LOGGER.warning("Attempt to (de-)serialize " + kind + " class " + name + "; see: https://jenkins.io/redirect/serialization-of-anonymous-classes/");
        } else {
            LOGGER.warning("Attempt to (de-)serialize " + kind + " class " + name + " in " + codeSource + "; see: https://jenkins.io/redirect/serialization-of-anonymous-classes/");
        }
    }

    @CheckForNull
    private static String codeSource(@NonNull Class<?> c) {
        CodeSource cs = c.getProtectionDomain().getCodeSource();
        if (cs == null) {
            return null;
        }
        URL loc = cs.getLocation();
        if (loc == null) {
            return null;
        }
        return loc.toString();
    }

    @NonNull
    public static ObjectOutputStream checkingObjectOutputStream(@NonNull OutputStream outputStream) throws IOException {
        return new ObjectOutputStream(outputStream){

            @Override
            protected void annotateClass(Class<?> c) throws IOException {
                AnonymousClassWarnings.check(c);
                super.annotateClass(c);
            }
        };
    }

    private AnonymousClassWarnings() {
    }
}

