/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTowerProjectSyncFreestyle
extends Builder {
    @Nonnull
    private String towerServer = "";
    private String towerCredentialsId = "";
    @Nonnull
    private String project = "";
    private Boolean verbose = DescriptorImpl.verbose;
    private Boolean importTowerLogs = DescriptorImpl.importTowerLogs;
    private Boolean removeColor = DescriptorImpl.removeColor;

    @DataBoundConstructor
    public AnsibleTowerProjectSyncFreestyle(@Nonnull String towerServer, String towerCredentialsId, @Nonnull String project, Boolean verbose, Boolean importTowerLogs, Boolean removeColor) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.project = project;
        this.verbose = verbose;
        this.importTowerLogs = importTowerLogs;
        this.removeColor = removeColor;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    @Nonnull
    public String getProject() {
        return this.project;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getImportTowerLogs() {
        return this.importTowerLogs;
    }

    public Boolean getRemoveColor() {
        return this.removeColor;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setImportTowerLogs(Boolean importTowerLogs) {
        this.importTowerLogs = importTowerLogs;
    }

    @DataBoundSetter
    public void setRemoveColor(Boolean removeColor) {
        this.removeColor = removeColor;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AnsibleTowerRunner runner = new AnsibleTowerRunner();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        boolean runResult = runner.projectSync(listener.getLogger(), this.getTowerServer(), this.getTowerCredentialsId(), this.project, this.verbose, this.importTowerLogs, this.getRemoveColor(), envVars, build.getWorkspace(), (Run<?, ?>)build, new Properties(), false);
        if (runResult) {
            build.setResult(Result.SUCCESS);
        } else {
            build.setResult(Result.FAILURE);
        }
        return runResult;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String towerServer = "";
        public static final String towerCredentialsId = "";
        public static final String project = "";
        public static final Boolean verbose = false;
        public static final Boolean importTowerLogs = false;
        public static final Boolean removeColor = false;
        public static final String templateType = "job";
        public static final Boolean throwExceptionWhenFail = true;
        public static final boolean async = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Ansible Tower Project Sync";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }
    }
}

