/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerProjectSyncFreestyle;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTowerProjectSyncStep
extends AbstractStepImpl {
    private String towerServer = "";
    private String towerCredentialsId = "";
    private String project = "";
    private Boolean verbose = false;
    private Boolean importTowerLogs = false;
    private Boolean removeColor = false;
    private Boolean throwExceptionWhenFail = true;
    private Boolean async = false;

    @DataBoundConstructor
    public AnsibleTowerProjectSyncStep(@Nonnull String towerServer, @Nonnull String towerCredentialsId, @Nonnull String project, Boolean verbose, Boolean importTowerLogs, Boolean removeColor, Boolean throwExceptionWhenFail, Boolean async) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.project = project;
        this.verbose = verbose;
        this.importTowerLogs = importTowerLogs;
        this.removeColor = removeColor;
        this.throwExceptionWhenFail = throwExceptionWhenFail;
        this.async = async;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    @Nonnull
    public String getProject() {
        return this.project;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getImportTowerLogs() {
        return this.importTowerLogs;
    }

    public Boolean getRemoveColor() {
        return this.removeColor;
    }

    public Boolean getThrowExceptionWhenFail() {
        return this.throwExceptionWhenFail;
    }

    public Boolean getAsync() {
        return this.async;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setImportTowerLogs(Boolean importTowerLogs) {
        this.importTowerLogs = importTowerLogs;
    }

    @DataBoundSetter
    public void setRemoveColor(Boolean removeColor) {
        this.removeColor = removeColor;
    }

    @DataBoundSetter
    public void setThrowExceptionWhenFail(Boolean throwExceptionWhenFail) {
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    @DataBoundSetter
    public void setAsync(Boolean async) {
        this.async = async;
    }

    public boolean isGlobalColorAllowed() {
        System.out.println("Using the class is global color allowed");
        return true;
    }

    public static final class AnsibleTowerProjectSyncStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Properties> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsibleTowerProjectSyncStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        protected Properties run() throws AbortException {
            if (this.computer == null || this.computer.getNode() == null) {
                throw new AbortException("The Ansible Tower Project Sync build step requires to be launched on a node");
            }
            AnsibleTowerRunner runner = new AnsibleTowerRunner();
            String project = "";
            if (this.step.getProject() != null) {
                project = this.step.getProject();
            }
            boolean verbose = false;
            if (this.step.getVerbose() != null) {
                verbose = this.step.getVerbose();
            }
            boolean importTowerLogs = false;
            if (this.step.getImportTowerLogs() != null) {
                importTowerLogs = this.step.getImportTowerLogs();
            }
            boolean removeColor = false;
            if (this.step.getRemoveColor() != null) {
                removeColor = this.step.getRemoveColor();
            }
            boolean throwExceptionWhenFail = true;
            if (this.step.getThrowExceptionWhenFail() != null) {
                throwExceptionWhenFail = this.step.getThrowExceptionWhenFail();
            }
            boolean async = false;
            if (this.step.getAsync() != null) {
                async = this.step.getAsync();
            }
            Properties map = new Properties();
            boolean runResult = runner.projectSync(this.listener.getLogger(), this.step.getTowerServer(), this.step.getTowerCredentialsId(), project, verbose, importTowerLogs, removeColor, this.envVars, this.ws, this.run, map, async);
            if (!runResult && throwExceptionWhenFail) {
                throw new AbortException("Ansible Tower Project Sync build step failed");
            }
            return map;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String towerServer = "";
        public static final String towerCredentailsId = "";
        public static final String project = "";
        public static final Boolean verbose = AnsibleTowerProjectSyncFreestyle.DescriptorImpl.verbose;
        public static final Boolean importTowerLogs = AnsibleTowerProjectSyncFreestyle.DescriptorImpl.importTowerLogs;
        public static final Boolean removeColor = AnsibleTowerProjectSyncFreestyle.DescriptorImpl.removeColor;
        public static final Boolean throwExceptionWhenFail = AnsibleTowerProjectSyncFreestyle.DescriptorImpl.throwExceptionWhenFail;
        public static final Boolean async = false;

        public DescriptorImpl() {
            super(AnsibleTowerProjectSyncStepExecution.class);
        }

        public String getFunctionName() {
            return "ansibleTowerProjectSync";
        }

        public String getDisplayName() {
            return "Have Ansible Tower update a Tower project";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        public boolean isGlobalColorAllowed() {
            System.out.println("Using the descriptor is global color allowed");
            return true;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }
    }
}

