/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Plugin;
import hudson.model.Run;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerException;
import org.jenkinsci.plugins.ansible_tower.util.TowerConnector;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.jenkinsci.plugins.ansible_tower.util.TowerJob;
import org.jenkinsci.plugins.ansible_tower.util.TowerProject;
import org.jenkinsci.plugins.ansible_tower.util.TowerProjectSync;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;

public class AnsibleTowerRunner {
    private TowerJob myJob = null;

    public boolean runJobTemplate(PrintStream logger, String towerServer, String towerCredentialsId, String jobTemplate, String jobType, String extraVars, String limit, String jobTags, String skipJobTags, String inventory, String credential, String scmBranch, boolean verbose, String importTowerLogs, boolean removeColor, EnvVars envVars, String templateType, boolean importWorkflowChildLogs, FilePath ws, Run<?, ?> run, Properties towerResults) {
        return this.runJobTemplate(logger, towerServer, towerCredentialsId, jobTemplate, jobType, extraVars, limit, jobTags, skipJobTags, inventory, credential, scmBranch, verbose, importTowerLogs, removeColor, envVars, templateType, importWorkflowChildLogs, ws, run, towerResults, false);
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public boolean runJobTemplate(PrintStream logger, String towerServer, String towerCredentialsId, String jobTemplate, String jobType, String extraVars, String limit, String jobTags, String skipJobTags, String inventory, String credential, String scmBranch, boolean verbose, String importTowerLogs, boolean removeColor, EnvVars envVars, String templateType, boolean importWorkflowChildLogs, FilePath ws, Run<?, ?> run, Properties towerResults, boolean async) {
        HashMap<String, String> jenkinsVariables;
        boolean wasSuccessful;
        JSONObject template;
        AnsibleTowerGlobalConfig myConfig;
        TowerInstallation towerConfigToRunOn;
        if (verbose) {
            logger.println("Beginning Ansible Tower Run on " + towerServer);
        }
        if ((towerConfigToRunOn = (myConfig = new AnsibleTowerGlobalConfig()).getTowerInstallationByName(towerServer)) == null) {
            logger.println("ERROR: Ansible tower server " + towerServer + " does not exist in Ansible Tower configuration");
            return false;
        }
        if (towerCredentialsId != null && !towerCredentialsId.equals("")) {
            towerConfigToRunOn.setTowerCredentialsId(towerCredentialsId);
        }
        if (run != null) {
            towerConfigToRunOn.setRun(run);
        }
        TowerConnector myTowerConnection = towerConfigToRunOn.getTowerConnector();
        this.myJob = new TowerJob(myTowerConnection);
        try {
            this.myJob.setTemplateType(templateType);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: " + e);
            return false;
        }
        if (!(importTowerLogs.matches("false") || importTowerLogs.matches("true") || importTowerLogs.matches("vars") || importTowerLogs.matches("full"))) {
            logger.println("ERROR: Import Tower Logs must be one of (false, true, vars or full)");
            return false;
        }
        if (jobTemplate != null && jobTemplate.equals("")) {
            jobTemplate = null;
        }
        if (extraVars != null && extraVars.equals("")) {
            extraVars = null;
        }
        if (limit != null && limit.equals("")) {
            limit = null;
        }
        if (jobTags != null && jobTags.equals("")) {
            jobTags = null;
        }
        if (skipJobTags != null && skipJobTags.equals("")) {
            skipJobTags = null;
        }
        if (inventory != null && inventory.equals("")) {
            inventory = null;
        }
        if (credential != null && credential.equals("")) {
            credential = null;
        }
        if (scmBranch != null && scmBranch.equals("")) {
            scmBranch = null;
        }
        String expandedJobTemplate = envVars.expand(jobTemplate);
        String expandedExtraVars = envVars.expand(extraVars);
        String expandedLimit = envVars.expand(limit);
        String expandedJobTags = envVars.expand(jobTags);
        String expandedSkipJobTags = envVars.expand(skipJobTags);
        String expandedInventory = envVars.expand(inventory);
        String expandedCredential = envVars.expand(credential);
        String expandedScmBranch = envVars.expand(scmBranch);
        if (verbose) {
            if (expandedJobTemplate != null && !expandedJobTemplate.equals(jobTemplate)) {
                logger.println("Expanded job template to " + expandedJobTemplate);
            }
            if (expandedExtraVars != null && !expandedExtraVars.equals(extraVars)) {
                logger.println("Expanded extra vars to " + expandedExtraVars);
            }
            if (expandedLimit != null && !expandedLimit.equals(limit)) {
                logger.println("Expanded limit to " + expandedLimit);
            }
            if (expandedJobTags != null && !expandedJobTags.equals(jobTags)) {
                logger.println("Expanded job tags to " + expandedJobTags);
            }
            if (expandedSkipJobTags != null && !expandedSkipJobTags.equals(skipJobTags)) {
                logger.println("Expanded skip job tags to " + expandedSkipJobTags);
            }
            if (expandedInventory != null && !expandedInventory.equals(inventory)) {
                logger.println("Expanded inventory to " + expandedInventory);
            }
            if (expandedCredential != null && !expandedCredential.equals(credential)) {
                logger.println("Expanded credentials to " + expandedCredential);
            }
            if (expandedScmBranch != null && !expandedScmBranch.equals(scmBranch)) {
                logger.println("Expanded scmBranch to " + expandedScmBranch);
            }
        }
        if (expandedJobTags != null && expandedJobTags.equalsIgnoreCase("") && !expandedJobTags.startsWith(",")) {
            expandedJobTags = "," + expandedJobTags;
        }
        if (expandedSkipJobTags != null && expandedSkipJobTags.equalsIgnoreCase("") && !expandedSkipJobTags.startsWith(",")) {
            expandedSkipJobTags = "," + expandedSkipJobTags;
        }
        try {
            template = myTowerConnection.getJobTemplate(expandedJobTemplate, templateType);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to lookup job template " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        if (jobType != null && template.containsKey((Object)"ask_job_type_on_launch") && !template.getBoolean("ask_job_type_on_launch")) {
            logger.println("[WARNING]: Job type defined but prompt for job type on launch is not set in tower job");
        }
        if (expandedExtraVars != null && template.containsKey((Object)"ask_variables_on_launch") && !template.getBoolean("ask_variables_on_launch")) {
            logger.println("[WARNING]: Extra variables defined but prompt for variables on launch is not set in tower job");
        }
        if (expandedLimit != null && template.containsKey((Object)"ask_limit_on_launch") && !template.getBoolean("ask_limit_on_launch")) {
            logger.println("[WARNING]: Limit defined but prompt for limit on launch is not set in tower job");
        }
        if (expandedJobTags != null && template.containsKey((Object)"ask_tags_on_launch") && !template.getBoolean("ask_tags_on_launch")) {
            logger.println("[WARNING]: Job Tags defined but prompt for tags on launch is not set in tower job");
        }
        if (expandedSkipJobTags != null && template.containsKey((Object)"ask_skip_tags_on_launch") && !template.getBoolean("ask_skip_tags_on_launch")) {
            logger.println("[WARNING]: Skip Job Tags defined but prompt for tags on launch is not set in tower job");
        }
        if (expandedInventory != null && template.containsKey((Object)"ask_inventory_on_launch") && !template.getBoolean("ask_inventory_on_launch")) {
            logger.println("[WARNING]: Inventory defined but prompt for inventory on launch is not set in tower job");
        }
        if (expandedCredential != null && template.containsKey((Object)"ask_credential_on_launch") && !template.getBoolean("ask_credential_on_launch")) {
            logger.println("[WARNING]: Credential defined but prompt for credential on launch is not set in tower job");
        }
        if (expandedScmBranch != null) {
            if (template.containsKey((Object)"ask_scm_branch_on_launch")) {
                if (!template.getBoolean("ask_scm_branch_on_launch")) {
                    logger.println("[WARNING]: SCM Branch defined but pompt for SCM back on launch is not set in tower job");
                }
            } else {
                logger.println("[WARNING]: SCM Branch defined but job template does not appear to support SCM branch on launch");
            }
        }
        myTowerConnection.setRemoveColor(removeColor);
        myTowerConnection.setGetWorkflowChildLogs(importWorkflowChildLogs);
        if (verbose) {
            logger.println("Requesting tower to run " + templateType + " template " + expandedJobTemplate);
        }
        try {
            this.myJob.setJobId(myTowerConnection.submitTemplate(template.getLong("id"), expandedExtraVars, expandedLimit, expandedJobTags, expandedSkipJobTags, jobType, expandedInventory, expandedCredential, expandedScmBranch, templateType));
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to request job template invocation " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        String jobURL = myTowerConnection.getJobURL(this.myJob.getJobID(), templateType);
        logger.println("Template Job URL: " + jobURL);
        towerResults.put("JOB_ID", Long.toString(this.myJob.getJobID()));
        towerResults.put("JOB_URL", jobURL);
        if (async) {
            towerResults.put("job", this.myJob);
            myTowerConnection.releaseToken();
            return true;
        }
        boolean jobCompleted = false;
        if (importTowerLogs.matches("full") || importTowerLogs.matches("vars")) {
            myTowerConnection.setGetFullLogs(true);
        }
        while (!jobCompleted) {
            if (Thread.currentThread().isInterrupted()) {
                myTowerConnection.releaseToken();
                return this.cancelJob(logger);
            }
            try {
                this.getJobLogs(importTowerLogs, logger);
            }
            catch (AnsibleTowerException e) {
                logger.println("ERROR: Failed to get job events from tower: " + e.getMessage());
                myTowerConnection.releaseToken();
                return false;
            }
            try {
                jobCompleted = this.myJob.isComplete();
            }
            catch (AnsibleTowerException e) {
                logger.println("ERROR: Failed to get job status from Tower: " + e.getMessage());
                myTowerConnection.releaseToken();
                return false;
            }
            if (jobCompleted) continue;
            if (Thread.currentThread().isInterrupted()) {
                myTowerConnection.releaseToken();
                return this.cancelJob(logger);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                myTowerConnection.releaseToken();
                return this.cancelJob(logger);
            }
        }
        try {
            this.getJobLogs(importTowerLogs, logger);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Failed to get final job events from tower: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        try {
            wasSuccessful = this.myJob.wasSuccessful();
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Failed to get job compltion status: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        try {
            jenkinsVariables = this.myJob.getExports();
        }
        catch (AnsibleTowerException e) {
            logger.println("Failed to get exported variables: " + e);
            myTowerConnection.releaseToken();
            return false;
        }
        for (Map.Entry<String, String> entrySet : jenkinsVariables.entrySet()) {
            if (verbose) {
                logger.println("Receiving from Jenkins job '" + entrySet.getKey() + "' with value '" + entrySet.getValue() + "'");
            }
            envVars.put(entrySet.getKey(), entrySet.getValue());
            towerResults.put(entrySet.getKey(), entrySet.getValue());
        }
        if (envVars.size() != 0) {
            EnvInjectActionSetter envInjectActionSetter;
            Plugin envInjectPlugin;
            Plugin plugin = envInjectPlugin = Jenkins.getInstance() != null ? Jenkins.getInstance().getPlugin("envinject") : null;
            if (envInjectPlugin != null) {
                envInjectActionSetter = new EnvInjectActionSetter(ws);
                try {
                    envInjectActionSetter.addEnvVarsToRun(run, (Map)envVars);
                }
                catch (Exception e) {
                    logger.println("Unable to inject environment variables: " + e.getMessage());
                    myTowerConnection.releaseToken();
                    return false;
                }
            }
            if (envInjectPlugin != null) {
                envInjectActionSetter = new EnvInjectActionSetter(ws);
                try {
                    envInjectActionSetter.addEnvVarsToRun(run, (Map)envVars);
                }
                catch (Exception e) {
                    logger.println("Unable to inject environment variables: " + e.getMessage());
                    myTowerConnection.releaseToken();
                    return false;
                }
            }
        }
        if (wasSuccessful) {
            logger.println("Tower completed the requested job");
        } else {
            logger.println("Tower failed to complete the requested job");
        }
        towerResults.put("JOB_RESULT", wasSuccessful ? "SUCCESS" : "FAILED");
        myTowerConnection.releaseToken();
        return wasSuccessful;
    }

    public void getJobLogs(String importTowerLogs, PrintStream logger) throws AnsibleTowerException {
        if (importTowerLogs.matches("false")) {
            return;
        }
        for (String event : this.myJob.getLogs()) {
            if (importTowerLogs.matches("vars")) continue;
            logger.println(event);
        }
    }

    public boolean cancelJob(PrintStream logger) {
        logger.println("Attempting to cancel launched Tower job");
        try {
            this.myJob.cancelJob();
            logger.println("Job successfully canceled in Tower");
        }
        catch (AnsibleTowerException ae) {
            logger.println("Failed to cancel tower job: " + ae);
        }
        return false;
    }

    public boolean cancelProjectSync(PrintStream logger, TowerProjectSync projectSync) {
        logger.println("Attempting to cancel project sync");
        try {
            projectSync.cancelSync();
            logger.println("Project sync successfullt canceled in Tower");
        }
        catch (AnsibleTowerException ae) {
            logger.println("Failed to cancel tower project sync: " + ae);
        }
        return false;
    }

    public boolean projectSync(PrintStream logger, String towerServer, String towerCredentialsId, String projectName, boolean verbose, boolean importTowerLogs, boolean removeColor, EnvVars envVars, FilePath ws, Run<?, ?> run, Properties towerResults, boolean async) {
        boolean wasSuccessful;
        TowerProjectSync projectSync;
        AnsibleTowerGlobalConfig myConfig;
        TowerInstallation towerConfigToRunOn;
        if (verbose) {
            logger.println("Beginning Ansible Tower Project Sync on " + towerServer + " for " + projectName);
        }
        if ((towerConfigToRunOn = (myConfig = new AnsibleTowerGlobalConfig()).getTowerInstallationByName(towerServer)) == null) {
            logger.println("ERROR: Ansible tower server " + towerServer + " does not exist in Ansible Tower configuration");
            return false;
        }
        if (towerCredentialsId != null && !towerCredentialsId.equals("")) {
            towerConfigToRunOn.setTowerCredentialsId(towerCredentialsId);
        }
        TowerConnector myTowerConnection = towerConfigToRunOn.getTowerConnector();
        myTowerConnection.setRemoveColor(removeColor);
        String expandedProject = envVars.expand(projectName);
        if (verbose && expandedProject != null && !expandedProject.equals(projectName)) {
            logger.println("Expanded project to " + expandedProject);
        }
        TowerProject myProject = null;
        try {
            myProject = new TowerProject(expandedProject, myTowerConnection);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to lookup project: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        try {
            if (!myProject.canUpdate()) {
                logger.println("ERROR: The requested project can not be synced, is it a manual project?");
                myTowerConnection.releaseToken();
                return false;
            }
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Failed to check if the project can be synced: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        if (verbose) {
            logger.println("Requesting tower to sync " + projectName + " template " + expandedProject);
        }
        try {
            projectSync = myProject.sync();
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to request project sync invocation " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        String syncURL = projectSync.getURL();
        logger.println("Project Sync URL: " + syncURL);
        towerResults.put("SYNC_ID", (Object)projectSync.getID());
        towerResults.put("SYNC_URL", syncURL);
        if (async) {
            towerResults.put("sync", projectSync);
            myTowerConnection.releaseToken();
            return true;
        }
        boolean syncCompleted = false;
        while (!syncCompleted) {
            if (Thread.currentThread().isInterrupted()) {
                myTowerConnection.releaseToken();
                return this.cancelProjectSync(logger, projectSync);
            }
            if (importTowerLogs) {
                try {
                    for (String event : projectSync.getLogs()) {
                        logger.println(event);
                    }
                }
                catch (AnsibleTowerException e) {
                    logger.println("ERROR: Failed to get project sync events from tower: " + e.getMessage());
                    myTowerConnection.releaseToken();
                    return false;
                }
            }
            try {
                syncCompleted = projectSync.isComplete();
            }
            catch (AnsibleTowerException e) {
                logger.println("ERROR: Failed to get project sync status from Tower: " + e.getMessage());
                myTowerConnection.releaseToken();
                return false;
            }
            if (syncCompleted) continue;
            if (Thread.currentThread().isInterrupted()) {
                myTowerConnection.releaseToken();
                return this.cancelProjectSync(logger, projectSync);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                myTowerConnection.releaseToken();
                return this.cancelProjectSync(logger, projectSync);
            }
        }
        if (importTowerLogs) {
            try {
                for (String event : projectSync.getLogs()) {
                    logger.println(event);
                }
            }
            catch (AnsibleTowerException e) {
                logger.println("ERROR: Failed to get final project sync events from tower: " + e.getMessage());
                myTowerConnection.releaseToken();
                return false;
            }
        }
        try {
            wasSuccessful = projectSync.wasSuccessful();
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Failed to get project sync compltion status: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        towerResults.put("SYNC_RESULT", wasSuccessful ? "SUCCESS" : "FAILED");
        if (wasSuccessful) {
            logger.println("Tower completed the requested project sync");
        } else {
            logger.println("Tower failed to complete the requested project sync");
        }
        myTowerConnection.releaseToken();
        return wasSuccessful;
    }

    public boolean projectRevision(PrintStream logger, String towerServer, String towerCredentialsId, String projectName, String revision, boolean verbose, EnvVars envVars, FilePath ws, Run<?, ?> run, Properties towerResults) {
        AnsibleTowerGlobalConfig myConfig;
        TowerInstallation towerConfigToRunOn;
        if (verbose) {
            logger.println("Beginning Ansible Tower Project Revision on " + towerServer + " for " + projectName);
        }
        if ((towerConfigToRunOn = (myConfig = new AnsibleTowerGlobalConfig()).getTowerInstallationByName(towerServer)) == null) {
            logger.println("ERROR: Ansible tower server " + towerServer + " does not exist in Ansible Tower configuration");
            return false;
        }
        if (towerCredentialsId != null && !towerCredentialsId.equals("")) {
            towerConfigToRunOn.setTowerCredentialsId(towerCredentialsId);
        }
        TowerConnector myTowerConnection = towerConfigToRunOn.getTowerConnector();
        String expandedProject = envVars.expand(projectName);
        String expandedRevision = envVars.expand(revision);
        if (verbose) {
            if (expandedProject != null && !expandedProject.equals(projectName)) {
                logger.println("Expanded project to " + expandedProject);
            }
            if (expandedRevision != null && !expandedRevision.equals(revision)) {
                logger.println("Expanded revision to " + expandedRevision);
            }
        }
        TowerProject myProject = null;
        try {
            myProject = new TowerProject(expandedProject, myTowerConnection);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to lookup project: " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
        if (verbose) {
            logger.println("Requesting tower to update " + expandedProject + " revision to " + expandedRevision);
        }
        try {
            return myProject.updateRevision(expandedRevision);
        }
        catch (AnsibleTowerException e) {
            logger.println("ERROR: Unable to update project revision " + e.getMessage());
            myTowerConnection.releaseToken();
            return false;
        }
    }
}

