/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTower;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTowerStep
extends AbstractStepImpl {
    private String towerServer = "";
    private String towerCredentialsId = "";
    private String jobTemplate = "";
    private String jobType = "run";
    private String extraVars = "";
    private String limit = "";
    private String jobTags = "";
    private String skipJobTags = "";
    private String inventory = "";
    private String credential = "";
    private String scmBranch = "";
    private Boolean verbose = false;
    private Boolean importTowerLogs = null;
    private String towerLogLevel = null;
    private Boolean removeColor = false;
    private String templateType = "job";
    private Boolean importWorkflowChildLogs = false;
    private Boolean throwExceptionWhenFail = true;
    private Boolean async = false;

    @Deprecated
    public AnsibleTowerStep(@Nonnull String towerServer, @Nonnull String towerCredentialsId, @Nonnull String jobTemplate, String jobType, String extraVars, String jobTags, String skipJobTags, String limit, String inventory, String credential, String scmBranch, Boolean verbose, Boolean importTowerLogs, Boolean removeColor, String templateType, Boolean importWorkflowChildLogs, Boolean throwExceptionWhenFail, Boolean async) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.jobTemplate = jobTemplate;
        this.extraVars = extraVars;
        this.jobTags = jobTags;
        this.skipJobTags = skipJobTags;
        this.jobType = jobType;
        this.limit = limit;
        this.inventory = inventory;
        this.credential = credential;
        this.scmBranch = scmBranch;
        this.verbose = verbose;
        this.towerLogLevel = importTowerLogs.toString();
        this.importTowerLogs = importTowerLogs;
        this.removeColor = removeColor;
        this.templateType = templateType;
        this.importWorkflowChildLogs = importWorkflowChildLogs;
        this.throwExceptionWhenFail = throwExceptionWhenFail;
        this.async = async;
    }

    @DataBoundConstructor
    public AnsibleTowerStep(@Nonnull String towerServer, @Nonnull String towerCredentialsId, @Nonnull String jobTemplate, String jobType) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.jobTemplate = jobTemplate;
        this.jobType = jobType;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    @Nonnull
    public String getJobTemplate() {
        return this.jobTemplate;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    public String getExtraVars() {
        return this.extraVars;
    }

    public String getJobTags() {
        return this.jobTags;
    }

    public String getSkipJobTags() {
        return this.skipJobTags;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getInventory() {
        return this.inventory;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getScmBranch() {
        return this.scmBranch;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getImportTowerLogs() {
        return this.importTowerLogs;
    }

    public String getTowerLogLevel() {
        return this.towerLogLevel;
    }

    public Boolean getRemoveColor() {
        return this.removeColor;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public Boolean getImportWorkflowChildLogs() {
        return this.importWorkflowChildLogs;
    }

    public Boolean getThrowExceptionWhenFail() {
        return this.throwExceptionWhenFail;
    }

    public Boolean getAsync() {
        return this.async;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setJobTemplate(String jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setExtraVars(String extraVars) {
        this.extraVars = extraVars;
    }

    @DataBoundSetter
    public void setJobTags(String jobTags) {
        this.jobTags = jobTags;
    }

    @DataBoundSetter
    public void setSkipJobTags(String skipJobTags) {
        this.skipJobTags = skipJobTags;
    }

    @DataBoundSetter
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @DataBoundSetter
    public void setLimit(String limit) {
        this.limit = limit;
    }

    @DataBoundSetter
    public void setInventory(String inventory) {
        this.inventory = inventory;
    }

    @DataBoundSetter
    public void setCredential(String credential) {
        this.credential = credential;
    }

    @DataBoundSetter
    public void setScmBranch(String scmBranch) {
        this.scmBranch = scmBranch;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setImportTowerLogs(Boolean importTowerLogs) {
        this.importTowerLogs = importTowerLogs;
        this.towerLogLevel = importTowerLogs.toString();
    }

    @DataBoundSetter
    public void setTowerLogLevel(String importTowerLogs) {
        this.towerLogLevel = importTowerLogs;
    }

    @DataBoundSetter
    public void setRemoveColor(Boolean removeColor) {
        this.removeColor = removeColor;
    }

    @DataBoundSetter
    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    @DataBoundSetter
    public void setImportWorkflowChildLogs(Boolean importWorkflowChildLogs) {
        this.importWorkflowChildLogs = importWorkflowChildLogs;
    }

    @DataBoundSetter
    public void setThrowExceptionWhenFail(Boolean throwExceptionWhenFail) {
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    @DataBoundSetter
    public void setAsync(Boolean async) {
        this.async = async;
    }

    public boolean isGlobalColorAllowed() {
        return true;
    }

    public static final class AnsibleTowerStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Properties> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsibleTowerStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        protected Properties run() throws AbortException {
            if (this.computer == null || this.computer.getNode() == null) {
                throw new AbortException("The Ansible Tower build step requires to be launched on a node");
            }
            AnsibleTowerRunner runner = new AnsibleTowerRunner();
            String towerCredentialsId = "";
            if (this.step.getTowerCredentialsId() != null) {
                towerCredentialsId = this.step.getTowerCredentialsId();
            }
            String extraVars = "";
            if (this.step.getExtraVars() != null) {
                extraVars = this.step.getExtraVars();
            }
            String limit = "";
            if (this.step.getLimit() != null) {
                limit = this.step.getLimit();
            }
            String tags = "";
            if (this.step.getJobTags() != null) {
                tags = this.step.getJobTags();
            }
            String skipTags = "";
            if (this.step.getSkipJobTags() != null) {
                skipTags = this.step.getSkipJobTags();
            }
            String jobType = "run";
            if (this.step.getJobType() != null) {
                jobType = this.step.getJobType();
            }
            String inventory = "";
            if (this.step.getInventory() != null) {
                inventory = this.step.getInventory();
            }
            String credential = "";
            if (this.step.getCredential() != null) {
                credential = this.step.getCredential();
            }
            String scmBranch = "";
            if (this.step.getScmBranch() != null) {
                scmBranch = this.step.getScmBranch();
            }
            boolean verbose = false;
            if (this.step.getVerbose() != null) {
                verbose = this.step.getVerbose();
            }
            String towerLogLevel = "false";
            if (this.step.getTowerLogLevel() != null) {
                towerLogLevel = this.step.getTowerLogLevel();
            }
            boolean removeColor = false;
            if (this.step.getRemoveColor() != null) {
                removeColor = this.step.getRemoveColor();
            }
            String templateType = "job";
            if (this.step.getTemplateType() != null) {
                templateType = this.step.getTemplateType();
            }
            boolean importWorkflowChildLogs = false;
            if (this.step.getImportWorkflowChildLogs() != null) {
                importWorkflowChildLogs = this.step.getImportWorkflowChildLogs();
            }
            boolean throwExceptionWhenFail = true;
            if (this.step.getThrowExceptionWhenFail() != null) {
                throwExceptionWhenFail = this.step.getThrowExceptionWhenFail();
            }
            boolean async = false;
            if (this.step.getAsync() != null) {
                async = this.step.getAsync();
            }
            Properties map = new Properties();
            boolean runResult = runner.runJobTemplate(this.listener.getLogger(), this.step.getTowerServer(), towerCredentialsId, this.step.getJobTemplate(), jobType, extraVars, limit, tags, skipTags, inventory, credential, scmBranch, verbose, towerLogLevel, removeColor, this.envVars, templateType, importWorkflowChildLogs, this.ws, this.run, map, async);
            if (!runResult && throwExceptionWhenFail) {
                throw new AbortException("Ansible Tower build step failed");
            }
            return map;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String towerServer = "";
        public static final String towerCredentialsId = "";
        public static final String jobTemplate = "";
        public static final String jobType = "run";
        public static final String extraVars = "";
        public static final String limit = "";
        public static final String jobTags = "";
        public static final String skipJobTags = "";
        public static final String inventory = "";
        public static final String credential = "";
        public static final String scmBranch = "";
        public static final Boolean verbose = AnsibleTower.DescriptorImpl.verbose;
        public static final String towerLogLevel = "false";
        public static final Boolean removeColor = AnsibleTower.DescriptorImpl.removeColor;
        public static final String templateType = "job";
        public static final Boolean importWorkflowChildLogs = AnsibleTower.DescriptorImpl.importWorkflowChildLogs;
        public static final Boolean throwExceptionWhenFail = AnsibleTower.DescriptorImpl.throwExceptionWhenFail;
        public static final Boolean async = false;

        public DescriptorImpl() {
            super(AnsibleTowerStepExecution.class);
        }

        public String getFunctionName() {
            return "ansibleTower";
        }

        public String getDisplayName() {
            return "Have Ansible Tower run a job template";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        public ListBoxModel doFillTemplateTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(templateType);
            items.add("workflow");
            return items;
        }

        public ListBoxModel doFillJobTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(jobType);
            items.add("check");
            return items;
        }

        public ListBoxModel doFillTowerLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Do not import", towerLogLevel);
            items.add("Import Truncated Logs", "true");
            items.add("Import Full Logs", "full");
            items.add("Process Variables Only", "vars");
            return items;
        }

        public boolean isGlobalColorAllowed() {
            return true;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }
    }
}

