/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerDoesNotSupportAuthToken;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerException;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerItemDoesNotExist;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerRefusesToGiveToken;
import org.jenkinsci.plugins.ansible_tower.util.TowerLogger;
import org.jenkinsci.plugins.ansible_tower.util.TowerVersion;
import org.jenkinsci.plugins.ansible_tower.util.TrustingSSLSocketFactory;

public class TowerConnector
implements Serializable {
    public static final int GET = 1;
    public static final int POST = 2;
    public static final int PATCH = 3;
    public static final String JOB_TEMPLATE_TYPE = "job";
    public static final String WORKFLOW_TEMPLATE_TYPE = "workflow";
    private static final String ARTIFACTS = "artifacts";
    private static String API_VERSION = "v2";
    private String authorizationHeader = null;
    private String oauthToken = null;
    private String oAuthTokenID = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private TowerVersion towerVersion = null;
    private boolean trustAllCerts = true;
    private boolean importChildWorkflowLogs = false;
    private TowerLogger logger = new TowerLogger();
    private HashMap<Long, Long> logIdForWorkflows = new HashMap();
    private HashMap<Long, Long> logIdForJobs = new HashMap();
    private boolean removeColor = true;
    private boolean getFullLogs = false;
    private HashMap<String, String> jenkinsExports = new HashMap();
    private static String UNIFIED_JOB_TYPE = "unified_job_type";
    private static String UNIFIED_JOB_TEMPLATE = "unified_job_template";

    public TowerConnector(String url, String username, String password) {
        this(url, username, password, null, false, false);
    }

    public TowerConnector(String url, String username, String password, String oauthToken, Boolean trustAllCerts, Boolean debug) {
        if (url != null && url.length() > 0 && url.charAt(url.length() - 1) == '/') {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        this.username = username;
        this.password = password;
        this.oauthToken = oauthToken;
        this.trustAllCerts = trustAllCerts;
        this.setDebug(debug);
        try {
            this.getVersion();
            this.logger.logMessage("Connecting to Tower version: " + this.towerVersion.getVersion());
        }
        catch (AnsibleTowerException ate) {
            this.logger.logMessage("Failed to get connection to get version; auth errors may ensue " + ate);
        }
        this.logger.logMessage("Created a connector with " + username + "@" + url);
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setDebug(boolean debug) {
        this.logger.setDebugging(debug);
    }

    public void setRemoveColor(boolean removeColor) {
        this.removeColor = removeColor;
    }

    public void setGetWorkflowChildLogs(boolean importChildWorkflowLogs) {
        this.importChildWorkflowLogs = importChildWorkflowLogs;
    }

    public void setGetFullLogs(boolean getFullLogs) {
        this.getFullLogs = getFullLogs;
    }

    public HashMap<String, String> getJenkinsExports() {
        return this.jenkinsExports;
    }

    private DefaultHttpClient getHttpClient() throws AnsibleTowerException {
        URI myURI = null;
        try {
            myURI = new URI(this.url);
        }
        catch (URISyntaxException urise) {
            throw new AnsibleTowerException("Unable to prase base url: " + urise);
        }
        if (this.trustAllCerts && myURI.getScheme().equalsIgnoreCase("https")) {
            TrustingSSLSocketFactory sf;
            this.logger.logMessage("Forcing cert trust");
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                sf = new TrustingSSLSocketFactory(trustStore);
            }
            catch (Exception e) {
                throw new AnsibleTowerException("Unable to create trusting SSL socket factory");
            }
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("https", (SocketFactory)sf, 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        return new DefaultHttpClient();
    }

    private String buildEndpoint(String endpoint) {
        if (endpoint.startsWith("/api/")) {
            return endpoint;
        }
        String full_endpoint = "/api/" + API_VERSION;
        if (!endpoint.startsWith("/")) {
            full_endpoint = full_endpoint + "/";
        }
        full_endpoint = full_endpoint + endpoint;
        return full_endpoint;
    }

    private HttpResponse makeRequest(int requestType, String endpoint) throws AnsibleTowerException {
        return this.makeRequest(requestType, endpoint, null, false);
    }

    private HttpResponse makeRequest(int requestType, String endpoint, JSONObject body) throws AnsibleTowerException, AnsibleTowerItemDoesNotExist {
        return this.makeRequest(requestType, endpoint, body, false);
    }

    public HttpResponse makeRequest(int requestType, String endpoint, JSONObject body, boolean noAuth) throws AnsibleTowerException, AnsibleTowerItemDoesNotExist {
        CloseableHttpResponse response;
        HttpGet request;
        URI myURI;
        try {
            myURI = new URI(this.url + this.buildEndpoint(endpoint));
        }
        catch (Exception e) {
            throw new AnsibleTowerException("URL issue: " + e.getMessage());
        }
        this.logger.logMessage("Building " + this.getMethodName(requestType) + " request to " + myURI.toString());
        if (requestType == 1) {
            request = new HttpGet(myURI);
        } else if (requestType == 2 || requestType == 3) {
            Object myRequest = requestType == 2 ? new HttpPost(myURI) : new HttpPatch(myURI);
            if (body != null && !body.isEmpty()) {
                try {
                    StringEntity bodyEntity = new StringEntity(body.toString());
                    myRequest.setEntity((HttpEntity)bodyEntity);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new AnsibleTowerException("Unable to encode body as JSON: " + uee.getMessage());
                }
            }
            request = myRequest;
            request.setHeader("Content-Type", "application/json");
        } else {
            throw new AnsibleTowerException("The requested method is unknown");
        }
        if (!noAuth) {
            if (this.authorizationHeader == null) {
                this.logger.logMessage("Determining authorization headers");
                if (this.oauthToken != null) {
                    this.logger.logMessage("Adding oauth bearer token from Jenkins");
                    this.authorizationHeader = "Bearer " + this.oauthToken;
                } else if (this.username != null && this.password != null) {
                    if (this.towerSupports("/api/o/")) {
                        this.logger.logMessage("Getting an oAuth token for " + this.username);
                        try {
                            this.authorizationHeader = "Bearer " + this.getOAuthToken();
                        }
                        catch (AnsibleTowerException ate) {
                            this.logger.logMessage("Unable to get oAuth Toekn: " + ate.getMessage());
                        }
                    }
                    if (this.authorizationHeader == null && this.towerSupports("/api/v2/authtoken")) {
                        this.logger.logMessage("Getting a legacy token for " + this.username);
                        try {
                            this.authorizationHeader = "Token " + this.getAuthToken();
                        }
                        catch (AnsibleTowerException ate) {
                            this.logger.logMessage("Unable to get legacuy token: " + ate.getMessage());
                        }
                    }
                    if (this.authorizationHeader == null) {
                        this.logger.logMessage("Tower does not support authtoken or oauth, reverting to basic auth");
                        this.authorizationHeader = this.getBasicAuthString();
                    }
                } else {
                    throw new AnsibleTowerException("Auth is required for this call but no auth info exists");
                }
            }
            if (this.authorizationHeader == null) {
                throw new AnsibleTowerException("We should have gotten an authorization header but did not");
            }
            request.setHeader("Authorization", this.authorizationHeader);
        }
        DefaultHttpClient httpClient = this.getHttpClient();
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            throw new AnsibleTowerException("Unable to make tower request: " + e.getMessage());
        }
        this.logger.logMessage("Request completed with (" + response.getStatusLine().getStatusCode() + ")");
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new AnsibleTowerItemDoesNotExist("The item does not exist");
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AnsibleTowerException("Username/password invalid");
        }
        if (response.getStatusLine().getStatusCode() == 403) {
            String exceptionText = "Request was forbidden";
            JSONObject responseObject = null;
            try {
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.logMessage(json);
                responseObject = JSONObject.fromObject((Object)json);
                if (responseObject.containsKey((Object)"detail")) {
                    exceptionText = exceptionText + ": " + responseObject.getString("detail");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new AnsibleTowerException(exceptionText);
        }
        return response;
    }

    private String dumpRequest(HttpUriRequest theRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("Request Method = [" + theRequest.getMethod() + "], ");
        sb.append("Request URL Path = [" + theRequest.getURI() + "], ");
        sb.append("[headers]");
        for (Header aHeader : theRequest.getAllHeaders()) {
            sb.append("    " + aHeader.getName() + ": " + aHeader.getValue());
        }
        return sb.toString();
    }

    private boolean towerSupports(String end_point) throws AnsibleTowerException {
        CloseableHttpResponse response;
        URI myURI;
        try {
            myURI = new URI(this.url + end_point);
        }
        catch (Exception e) {
            throw new AnsibleTowerException("Unable to construct URL for " + end_point + ": " + e.getMessage());
        }
        this.logger.logMessage("Checking if Tower can: " + myURI.toString());
        DefaultHttpClient httpClient = this.getHttpClient();
        try {
            response = httpClient.execute((HttpUriRequest)new HttpHead(myURI));
        }
        catch (Exception e) {
            throw new AnsibleTowerException("Unable to make Tower HEAD request for " + end_point + ": " + e.getMessage());
        }
        this.logger.logMessage("Can Tower request completed with (" + response.getStatusLine().getStatusCode() + ")");
        if (response.getStatusLine().getStatusCode() == 404) {
            this.logger.logMessage("Tower does not supoort " + end_point);
            return false;
        }
        this.logger.logMessage("Tower supoorts " + end_point);
        return true;
    }

    public String getURL() {
        return this.url;
    }

    public void getVersion() throws AnsibleTowerException {
        JSONObject responseObject;
        HttpResponse response = this.makeRequest(1, "ping/", null, true);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned from ping connection (" + response.getStatusLine().getStatusCode() + ")");
        }
        this.logger.logMessage("Ping page loaded");
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            responseObject = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read ping response and convert it into json: " + ioe.getMessage());
        }
        if (responseObject.containsKey((Object)"version")) {
            this.logger.logMessage("Successfully got version " + responseObject.getString("version"));
            this.towerVersion = new TowerVersion(responseObject.getString("version"));
        }
    }

    public void testConnection() throws AnsibleTowerException {
        if (this.url == null) {
            throw new AnsibleTowerException("The URL is undefined");
        }
        this.logger.logMessage("Testing authentication");
        HttpResponse response = this.makeRequest(1, "jobs/");
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Failed to get authenticated connection (" + response.getStatusLine().getStatusCode() + ")");
        }
        this.releaseToken();
    }

    public String convertPotentialStringToID(String idToCheck, String api_endpoint) throws AnsibleTowerException, AnsibleTowerItemDoesNotExist {
        JSONObject foundItem = this.rawLookupByString(idToCheck, api_endpoint);
        this.logger.logMessage("Response from lookup: " + foundItem.getString("id"));
        return foundItem.getString("id");
    }

    public JSONObject rawLookupByString(String idToCheck, String api_endpoint) throws AnsibleTowerException, AnsibleTowerItemDoesNotExist {
        try {
            JSONObject responseObject;
            Integer.parseInt(idToCheck);
            HttpResponse response = this.makeRequest(1, api_endpoint + idToCheck + "/");
            try {
                responseObject = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                if (!responseObject.containsKey((Object)"id")) {
                    throw new AnsibleTowerItemDoesNotExist("Did not get an ID back from the request");
                }
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException(ioe.getMessage());
            }
            return responseObject;
        }
        catch (NumberFormatException nfe) {
            JSONObject responseObject;
            HttpResponse response = null;
            try {
                response = this.makeRequest(1, api_endpoint + "?name=" + URLEncoder.encode(idToCheck, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AnsibleTowerException("Unable to encode item name for lookup");
            }
            try {
                responseObject = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to convert response for all items into json: " + ioe.getMessage());
            }
            if (!responseObject.containsKey((Object)"results")) {
                throw new AnsibleTowerException("Response for items does not contain results");
            }
            if (responseObject.getInt("count") == 0) {
                throw new AnsibleTowerException("Unable to get any results when looking up " + idToCheck);
            }
            if (responseObject.getInt("count") > 1) {
                throw new AnsibleTowerException("The item " + idToCheck + " is not unique");
            }
            JSONObject foundItem = (JSONObject)responseObject.getJSONArray("results").get(0);
            return foundItem;
        }
    }

    public JSONObject getJobTemplate(String jobTemplate, String templateType) throws AnsibleTowerException {
        if (jobTemplate == null || jobTemplate.isEmpty()) {
            throw new AnsibleTowerException("Template can not be null");
        }
        this.checkTemplateType(templateType);
        String apiEndPoint = "/job_templates/";
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            apiEndPoint = "/workflow_job_templates/";
        }
        try {
            jobTemplate = this.convertPotentialStringToID(jobTemplate, apiEndPoint);
        }
        catch (AnsibleTowerItemDoesNotExist atidne) {
            String ucTemplateType = templateType.replaceFirst(templateType.substring(0, 1), templateType.substring(0, 1).toUpperCase());
            throw new AnsibleTowerException(ucTemplateType + " template does not exist in tower");
        }
        catch (AnsibleTowerException ate) {
            throw new AnsibleTowerException("Unable to find " + templateType + " template: " + ate.getMessage());
        }
        HttpResponse response = this.makeRequest(1, apiEndPoint + jobTemplate + "/");
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned when getting template (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read template response and convert it into json: " + ioe.getMessage());
        }
    }

    private void processCredentials(String credential, JSONObject postBody) throws AnsibleTowerException {
        JSONObject responseObject;
        HttpResponse response = this.makeRequest(1, "/credential_types/?or__kind=ssh&or__kind=vault");
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unable to lookup the credential types");
        }
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            responseObject = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
        }
        if (responseObject.getInt("count") != 2) {
            throw new AnsibleTowerException("Unable to find both machine and vault credentials type");
        }
        long machine_credential_type = -1L;
        long vault_credential_type = -1L;
        JSONArray credentialTypesArray = responseObject.getJSONArray("results");
        for (JSONObject aCredentialType : credentialTypesArray) {
            if (aCredentialType.getString("kind").equalsIgnoreCase("ssh")) {
                machine_credential_type = aCredentialType.getLong("id");
                continue;
            }
            if (!aCredentialType.getString("kind").equalsIgnoreCase("vault")) continue;
            vault_credential_type = aCredentialType.getLong("id");
        }
        if (vault_credential_type == -1L) {
            this.logger.logMessage("[ERROR]: Unable to find vault credential type");
        }
        if (machine_credential_type == -1L) {
            this.logger.logMessage("[ERROR]: Unable to find machine credential type");
        }
        HashMap credentials = new HashMap();
        credentials.put("vault", new Vector());
        credentials.put("machine", new Vector());
        credentials.put("extra", new Vector());
        for (String credentialString : credential.split(",")) {
            try {
                JSONObject jsonCredential = this.rawLookupByString(credentialString, "/credentials/");
                String myCredentialType = null;
                int credentialTypeId = jsonCredential.getInt("credential_type");
                myCredentialType = (long)credentialTypeId == machine_credential_type ? "machine" : ((long)credentialTypeId == vault_credential_type ? "vault" : "extra");
                ((Vector)credentials.get(myCredentialType)).add(jsonCredential.getLong("id"));
            }
            catch (AnsibleTowerItemDoesNotExist ateide) {
                throw new AnsibleTowerException("Credential " + credentialString + " does not exist in tower");
            }
            catch (AnsibleTowerException ate) {
                throw new AnsibleTowerException("Unable to find credential " + credentialString + ": " + ate.getMessage());
            }
        }
        if (this.towerVersion.is_greater_or_equal("3.5.0") || ((Vector)credentials.get("machine")).size() > 1 || ((Vector)credentials.get("vault")).size() > 1) {
            JSONArray allCredentials = new JSONArray();
            allCredentials.addAll((Collection)credentials.get("machine"));
            allCredentials.addAll((Collection)credentials.get("vault"));
            allCredentials.addAll((Collection)credentials.get("extra"));
            postBody.put("credentials", (Object)allCredentials);
        } else {
            if (((Vector)credentials.get("machine")).size() > 0) {
                postBody.put("credential", ((Vector)credentials.get("machine")).get(0));
            }
            if (((Vector)credentials.get("vault")).size() > 0) {
                postBody.put("vault_credential", ((Vector)credentials.get("vault")).get(0));
            }
            if (((Vector)credentials.get("extra")).size() > 0) {
                JSONArray extraCredentials = new JSONArray();
                extraCredentials.addAll((Collection)credentials.get("extra"));
                postBody.put("extra_credentials", (Object)extraCredentials);
            }
        }
    }

    public long submitTemplate(long jobTemplate, String extraVars, String limit, String jobTags, String skipJobTags, String jobType, String inventory, String credential, String scmBranch, String templateType) throws AnsibleTowerException {
        HttpResponse response;
        this.checkTemplateType(templateType);
        String apiEndPoint = "/job_templates/";
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            apiEndPoint = "/workflow_job_templates/";
        }
        JSONObject postBody = new JSONObject();
        if (inventory != null && !inventory.isEmpty()) {
            try {
                inventory = this.convertPotentialStringToID(inventory, "/inventories/");
            }
            catch (AnsibleTowerItemDoesNotExist atidne) {
                throw new AnsibleTowerException("Inventory " + inventory + " does not exist in tower");
            }
            catch (AnsibleTowerException ate) {
                throw new AnsibleTowerException("Unable to find inventory: " + ate.getMessage());
            }
            postBody.put("inventory", (Object)inventory);
        }
        if (credential != null && !credential.isEmpty()) {
            this.processCredentials(credential, postBody);
        }
        if (limit != null && !limit.isEmpty()) {
            postBody.put("limit", (Object)limit);
        }
        if (jobTags != null && !jobTags.isEmpty()) {
            postBody.put("job_tags", (Object)jobTags);
        }
        if (skipJobTags != null && !skipJobTags.isEmpty()) {
            postBody.put("skip_tags", (Object)skipJobTags);
        }
        if (jobType != null && !jobType.isEmpty()) {
            postBody.put("job_type", (Object)jobType);
        }
        if (extraVars != null && !extraVars.isEmpty()) {
            postBody.put("extra_vars", (Object)extraVars);
        }
        if (scmBranch != null && !scmBranch.isEmpty()) {
            postBody.put("scm_branch", (Object)scmBranch);
        }
        if ((response = this.makeRequest(2, apiEndPoint + jobTemplate + "/launch/", postBody)).getStatusLine().getStatusCode() == 201) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            if (responseObject.containsKey((Object)"id")) {
                return responseObject.getLong("id");
            }
            this.logger.logMessage(json);
            throw new AnsibleTowerException("Did not get an ID from the request. Template response can be found in the jenkins.log");
        }
        if (response.getStatusLine().getStatusCode() == 400) {
            String json = null;
            JSONObject responseObject = null;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (Exception e) {
                this.logger.logMessage("Unable to parse 400 response from json to get details: " + e.getMessage());
                this.logger.logMessage(json);
            }
            if (responseObject != null && responseObject.containsKey((Object)"extra_vars")) {
                throw new AnsibleTowerException("Extra vars are bad: " + responseObject.getString("extra_vars"));
            }
            throw new AnsibleTowerException("Tower received a bad request (400 response code)\n" + json);
        }
        throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
    }

    public void checkTemplateType(String templateType) throws AnsibleTowerException {
        if (templateType.equalsIgnoreCase(JOB_TEMPLATE_TYPE)) {
            return;
        }
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            return;
        }
        throw new AnsibleTowerException("Template type can only be 'job' or 'workflow'");
    }

    public boolean isJobCompleted(long jobID, String templateType) throws AnsibleTowerException {
        HttpResponse response;
        this.checkTemplateType(templateType);
        String apiEndpoint = "/jobs/" + jobID + "/";
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            apiEndpoint = "/workflow_jobs/" + jobID + "/";
        }
        if ((response = this.makeRequest(1, apiEndpoint)).getStatusLine().getStatusCode() == 200) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            if (responseObject.containsKey((Object)"finished")) {
                String finished = responseObject.getString("finished");
                if (finished == null || finished.equalsIgnoreCase("null")) {
                    return false;
                }
                if (responseObject.containsKey((Object)ARTIFACTS)) {
                    this.logger.logMessage("Processing artifacts");
                    JSONObject artifacts = responseObject.getJSONObject(ARTIFACTS);
                    if (artifacts.containsKey((Object)"JENKINS_EXPORT")) {
                        JSONArray exportVariables = artifacts.getJSONArray("JENKINS_EXPORT");
                        for (JSONObject entry : exportVariables) {
                            Iterator keyIterator = entry.keys();
                            while (keyIterator.hasNext()) {
                                String key = (String)keyIterator.next();
                                this.jenkinsExports.put(key, entry.getString(key));
                            }
                        }
                    }
                }
                return true;
            }
            this.logger.logMessage(json);
            throw new AnsibleTowerException("Did not get a failed status from the request. Job response can be found in the jenkins.log");
        }
        throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
    }

    public void cancelJob(long jobID, String templateType) throws AnsibleTowerException {
        boolean canCancel;
        JSONObject responseObject;
        String json;
        HttpResponse response;
        this.checkTemplateType(templateType);
        String apiEndpoint = "/jobs/" + jobID + "/";
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            apiEndpoint = "/workflow_jobs/" + jobID + "/";
        }
        if ((response = this.makeRequest(1, apiEndpoint = apiEndpoint + "cancel/")).getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity());
            responseObject = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
        }
        if (responseObject.containsKey((Object)"can_cancel") && !(canCancel = responseObject.getBoolean("can_cancel"))) {
            throw new AnsibleTowerException("The job can not be canceled at this time");
        }
        response = this.makeRequest(2, apiEndpoint);
        if (response.getStatusLine().getStatusCode() != 202) {
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode());
        }
        for (int counter = 10; counter > 0; --counter) {
            boolean canCancel2;
            response = this.makeRequest(1, apiEndpoint);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
            }
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            if (responseObject.containsKey((Object)"can_cancel") && !(canCancel2 = responseObject.getBoolean("can_cancel"))) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ie) {
                throw new AnsibleTowerException("Interrupted while attempting to cancel job");
            }
        }
        throw new AnsibleTowerException("Failed to cancel the job within the specified time limit");
    }

    @Deprecated
    public boolean isJobCommpleted(long jobID, String templateType) throws AnsibleTowerException {
        return this.isJobCompleted(jobID, templateType);
    }

    public Vector<String> getLogEvents(long jobID, String templateType) throws AnsibleTowerException {
        Vector<String> events = new Vector<String>();
        this.checkTemplateType(templateType);
        if (templateType.equalsIgnoreCase(JOB_TEMPLATE_TYPE)) {
            events.addAll(this.logJobEvents(jobID));
        } else if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            events.addAll(this.logWorkflowEvents(jobID, this.importChildWorkflowLogs));
        } else {
            throw new AnsibleTowerException("Tower Connector does not know how to log events for a " + templateType);
        }
        return events;
    }

    private Vector<String> logWorkflowEvents(long jobID, boolean importWorkflowChildLogs) throws AnsibleTowerException {
        HttpResponse response;
        Vector<String> events = new Vector<String>();
        if (!this.logIdForWorkflows.containsKey(jobID)) {
            this.logIdForWorkflows.put(jobID, 0L);
        }
        if ((response = this.makeRequest(1, "/workflow_jobs/" + jobID + "/workflow_nodes/?id__gt=" + this.logIdForWorkflows.get(jobID))).getStatusLine().getStatusCode() == 200) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            this.logger.logMessage(json);
            if (responseObject.containsKey((Object)"results")) {
                for (Object anEventObject : responseObject.getJSONArray("results")) {
                    JSONObject templateType;
                    JSONObject summaryFields;
                    JSONObject anEvent = (JSONObject)anEventObject;
                    long eventId = anEvent.getLong("id");
                    if (!anEvent.containsKey((Object)"summary_fields") || !(summaryFields = anEvent.getJSONObject("summary_fields")).containsKey((Object)JOB_TEMPLATE_TYPE) || !summaryFields.containsKey((Object)UNIFIED_JOB_TEMPLATE) || !(templateType = summaryFields.getJSONObject(UNIFIED_JOB_TEMPLATE)).containsKey((Object)UNIFIED_JOB_TYPE)) continue;
                    JSONObject job = summaryFields.getJSONObject(JOB_TEMPLATE_TYPE);
                    if (!job.containsKey((Object)"status") || job.getString("status").equalsIgnoreCase("running") || job.getString("status").equalsIgnoreCase("pending")) {
                        return events;
                    }
                    if (eventId > this.logIdForWorkflows.get(jobID)) {
                        this.logIdForWorkflows.put(jobID, eventId);
                    }
                    events.addAll(this.logLine(job.getString("name") + " => " + job.getString("status") + " " + this.getJobURL(job.getLong("id"), JOB_TEMPLATE_TYPE)));
                    if (importWorkflowChildLogs) {
                        if (templateType.getString(UNIFIED_JOB_TYPE).equalsIgnoreCase(JOB_TEMPLATE_TYPE)) {
                            events.addAll(this.logJobEvents(job.getLong("id")));
                        } else if (templateType.getString(UNIFIED_JOB_TYPE).equalsIgnoreCase("project_update")) {
                            events.addAll(this.logProjectSync(job.getLong("id")));
                        } else if (templateType.getString(UNIFIED_JOB_TYPE).equalsIgnoreCase("inventory_update")) {
                            events.addAll(this.logInventorySync(job.getLong("id")));
                        } else {
                            events.addAll(this.logLine("Unknown job type in workflow: " + templateType.getString(UNIFIED_JOB_TYPE)));
                        }
                    }
                    events.addAll(this.logLine(""));
                    events.addAll(this.logLine(""));
                }
            }
        } else {
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
        }
        return events;
    }

    public Vector<String> logLine(String output) throws AnsibleTowerException {
        String[] lines;
        Vector<String> return_lines = new Vector<String>();
        for (String line : lines = output.split("\\r\\n")) {
            String[] entities;
            if (line.matches("^.*JENKINS_EXPORT.*$") && (entities = this.removeColor(line).split("=", 2)).length == 2) {
                entities[0] = entities[0].replaceAll(".*JENKINS_EXPORT ", "");
                entities[1] = entities[1].replaceAll("\"$", "");
                this.jenkinsExports.put(entities[0], entities[1]);
            }
            if (this.removeColor) {
                line = this.removeColor(line);
            }
            return_lines.add(line);
        }
        return return_lines;
    }

    private String removeColor(String coloredLine) {
        return coloredLine.replaceAll("\u001b\\[[;\\d]*m", "");
    }

    private Vector<String> logInventorySync(long syncID) throws AnsibleTowerException {
        Vector<String> events = new Vector<String>();
        String apiURL = "/inventory_updates/" + syncID + "/";
        HttpResponse response = this.makeRequest(1, apiURL);
        if (response.getStatusLine().getStatusCode() == 200) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            this.logger.logMessage(json);
            if (responseObject.containsKey((Object)"result_stdout")) {
                events.addAll(this.logLine(responseObject.getString("result_stdout")));
            }
        } else {
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
        }
        return events;
    }

    private Vector<String> logProjectSync(long syncID) throws AnsibleTowerException {
        Vector<String> events = new Vector<String>();
        String apiURL = "/project_updates/" + syncID + "/";
        HttpResponse response = this.makeRequest(1, apiURL);
        if (response.getStatusLine().getStatusCode() == 200) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            this.logger.logMessage(json);
            if (responseObject.containsKey((Object)"result_stdout")) {
                events.addAll(this.logLine(responseObject.getString("result_stdout")));
            }
        } else {
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
        }
        return events;
    }

    private Vector<String> logJobEvents(long jobID) throws AnsibleTowerException {
        Vector<String> events = new Vector<String>();
        if (!this.logIdForJobs.containsKey(jobID)) {
            this.logIdForJobs.put(jobID, 0L);
        }
        boolean keepChecking = true;
        while (keepChecking) {
            String apiURL = "/jobs/" + jobID + "/job_events/?id__gt=" + this.logIdForJobs.get(jobID);
            HttpResponse response = this.makeRequest(1, apiURL);
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject responseObject;
                String json;
                try {
                    json = EntityUtils.toString((HttpEntity)response.getEntity());
                    responseObject = JSONObject.fromObject((Object)json);
                }
                catch (IOException ioe) {
                    throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
                }
                this.logger.logMessage(json);
                if (responseObject.containsKey((Object)"next") && responseObject.getString("next") == null || responseObject.getString("next").equalsIgnoreCase("null")) {
                    keepChecking = false;
                }
                if (!responseObject.containsKey((Object)"results")) continue;
                for (Object anEvent : responseObject.getJSONArray("results")) {
                    JSONObject eventObject = (JSONObject)anEvent;
                    long eventId = eventObject.getLong("id");
                    String stdOut = eventObject.getString("stdout");
                    if (this.getFullLogs) {
                        try {
                            stdOut = eventObject.getJSONObject("event_data").getJSONObject("res").getString("msg");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    events.addAll(this.logLine(stdOut));
                    if (eventId <= this.logIdForJobs.get(jobID)) continue;
                    this.logIdForJobs.put(jobID, eventId);
                }
                continue;
            }
            throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
        }
        return events;
    }

    public boolean isJobFailed(long jobID, String templateType) throws AnsibleTowerException {
        HttpResponse response;
        this.checkTemplateType(templateType);
        String apiEndPoint = "/jobs/" + jobID + "/";
        if (templateType.equalsIgnoreCase(WORKFLOW_TEMPLATE_TYPE)) {
            apiEndPoint = "/workflow_jobs/" + jobID + "/";
        }
        if ((response = this.makeRequest(1, apiEndPoint)).getStatusLine().getStatusCode() == 200) {
            JSONObject responseObject;
            String json;
            try {
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                responseObject = JSONObject.fromObject((Object)json);
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
            }
            if (responseObject.containsKey((Object)"failed")) {
                return responseObject.getBoolean("failed");
            }
            this.logger.logMessage(json);
            throw new AnsibleTowerException("Did not get a failed status from the request. Job response can be found in the jenkins.log");
        }
        throw new AnsibleTowerException("Unexpected error code returned (" + response.getStatusLine().getStatusCode() + ")");
    }

    public String getJobURL(long myJobID, String templateType) {
        String returnURL = this.url + "/#/";
        returnURL = templateType.equalsIgnoreCase(JOB_TEMPLATE_TYPE) ? returnURL + "jobs" : returnURL + "workflows";
        returnURL = returnURL + "/" + myJobID;
        return returnURL;
    }

    private String getBasicAuthString() {
        String auth = this.username + ":" + this.password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("UTF-8")));
        return "Basic " + new String(encodedAuth, Charset.forName("UTF-8"));
    }

    private String getOAuthToken() throws AnsibleTowerException {
        JSONObject responseObject;
        String json;
        CloseableHttpResponse response;
        String tokenURI = this.url + this.buildEndpoint("/tokens/");
        HttpPost oauthTokenRequest = new HttpPost(tokenURI);
        oauthTokenRequest.setHeader("Authorization", this.getBasicAuthString());
        JSONObject body = new JSONObject();
        body.put("description", (Object)"Jenkins Token");
        body.put("application", null);
        body.put("scope", (Object)"write");
        try {
            StringEntity bodyEntity = new StringEntity(body.toString());
            oauthTokenRequest.setEntity((HttpEntity)bodyEntity);
        }
        catch (UnsupportedEncodingException uee) {
            throw new AnsibleTowerException("Unable to encode body as JSON: " + uee.getMessage());
        }
        oauthTokenRequest.setHeader("Content-Type", "application/json");
        DefaultHttpClient httpClient = this.getHttpClient();
        try {
            this.logger.logMessage("Calling for oauth token at " + tokenURI);
            response = httpClient.execute((HttpUriRequest)oauthTokenRequest);
        }
        catch (Exception e) {
            throw new AnsibleTowerException("Unable to make request for an oauth token: " + e.getMessage());
        }
        if (response.getStatusLine().getStatusCode() == 400 || response.getStatusLine().getStatusCode() == 401) {
            throw new AnsibleTowerException("Username/password invalid");
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new AnsibleTowerDoesNotSupportAuthToken("Server does not have tokens endpoint: " + tokenURI);
        }
        if (response.getStatusLine().getStatusCode() == 403) {
            throw new AnsibleTowerRefusesToGiveToken("Server refuses to give tokens");
        }
        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
            throw new AnsibleTowerException("Unable to get oauth token, server responded with (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity());
            responseObject = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read oatuh response and convert it into json: " + ioe.getMessage());
        }
        if (responseObject.containsKey((Object)"id")) {
            this.oAuthTokenID = responseObject.getString("id");
        }
        if (responseObject.containsKey((Object)"token")) {
            this.logger.logMessage("AuthToken acquired (" + this.oAuthTokenID + ")");
            return responseObject.getString("token");
        }
        this.logger.logMessage(json);
        throw new AnsibleTowerException("Did not get an oauth token from the request. Template response can be found in the jenkins.log");
    }

    private String getAuthToken() throws AnsibleTowerException {
        JSONObject responseObject;
        String json;
        CloseableHttpResponse response;
        this.logger.logMessage("Getting auth token for " + this.username);
        String tokenURI = this.url + this.buildEndpoint("/authtoken/");
        HttpPost tokenRequest = new HttpPost(tokenURI);
        tokenRequest.setHeader("Authorization", this.getBasicAuthString());
        JSONObject body = new JSONObject();
        body.put("username", (Object)this.username);
        body.put("password", (Object)this.password);
        try {
            StringEntity bodyEntity = new StringEntity(body.toString());
            tokenRequest.setEntity((HttpEntity)bodyEntity);
        }
        catch (UnsupportedEncodingException uee) {
            throw new AnsibleTowerException("Unable to encode body as JSON: " + uee.getMessage());
        }
        tokenRequest.setHeader("Content-Type", "application/json");
        DefaultHttpClient httpClient = this.getHttpClient();
        try {
            this.logger.logMessage("Calling for token at " + tokenURI);
            response = httpClient.execute((HttpUriRequest)tokenRequest);
        }
        catch (Exception e) {
            throw new AnsibleTowerException("Unable to make request for an authtoken: " + e.getMessage());
        }
        if (response.getStatusLine().getStatusCode() == 400) {
            throw new AnsibleTowerException("Username/password invalid");
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new AnsibleTowerDoesNotSupportAuthToken("Server does not have endpoint: " + tokenURI);
        }
        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
            throw new AnsibleTowerException("Unable to get auth token, server responded with (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity());
            responseObject = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read response and convert it into json: " + ioe.getMessage());
        }
        if (responseObject.containsKey((Object)"token")) {
            this.logger.logMessage("AuthToken acquired");
            return responseObject.getString("token");
        }
        this.logger.logMessage(json);
        throw new AnsibleTowerException("Did not get a token from the request. Template response can be found in the jenkins.log");
    }

    public void releaseToken() {
        if (this.oAuthTokenID != null) {
            this.logger.logMessage("Deleting oAuth token " + this.oAuthTokenID + " for " + this.username);
            try {
                String tokenURI = this.url + this.buildEndpoint("/tokens/" + this.oAuthTokenID + "/");
                HttpDelete tokenRequest = new HttpDelete(tokenURI);
                tokenRequest.setHeader("Authorization", this.getBasicAuthString());
                DefaultHttpClient httpClient = this.getHttpClient();
                this.logger.logMessage("Calling for oAuth token delete at " + tokenURI);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)tokenRequest);
                if (response.getStatusLine().getStatusCode() == 400) {
                    this.logger.logMessage("Unable to delete oAuthToken: Invalid Authorization");
                } else if (response.getStatusLine().getStatusCode() != 204) {
                    this.logger.logMessage("Unable to delete oauth token, server responded with (" + response.getStatusLine().getStatusCode() + ")");
                }
                this.logger.logMessage("oAuth Token deleted");
                this.oAuthTokenID = null;
                this.authorizationHeader = null;
            }
            catch (Exception e) {
                this.logger.logMessage("Failed to delete token: " + e.getMessage());
            }
        }
    }

    public String getMethodName(int methodId) {
        if (methodId == 1) {
            return "GET";
        }
        if (methodId == 2) {
            return "POST";
        }
        if (methodId == 3) {
            return "PATCH";
        }
        return "UNKNOWN";
    }
}

