/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower.util;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Run;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ansible_tower.util.TowerConnector;
import org.jenkinsci.plugins.ansible_tower.util.TowerLogger;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class TowerInstallation
extends AbstractDescribableImpl<TowerInstallation> {
    private static final long getSerialVersionUID = 1L;
    private final String towerDisplayName;
    private final String towerURL;
    private String towerCredentialsId;
    private final boolean towerTrustCert;
    private final boolean enableDebugging;
    private Run run;

    @DataBoundConstructor
    public TowerInstallation(String towerDisplayName, String towerURL, String towerCredentialsId, boolean towerTrustCert, boolean enableDebugging) {
        this.towerDisplayName = towerDisplayName;
        this.towerCredentialsId = towerCredentialsId;
        this.towerURL = towerURL;
        this.towerTrustCert = towerTrustCert;
        this.enableDebugging = enableDebugging;
    }

    public String getTowerDisplayName() {
        return this.towerDisplayName;
    }

    public String getTowerURL() {
        return this.towerURL;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    public boolean getTowerTrustCert() {
        return this.towerTrustCert;
    }

    public boolean getEnableDebugging() {
        return this.enableDebugging;
    }

    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    public void setRun(Run run) {
        this.run = run;
    }

    public TowerConnector getTowerConnector() {
        return TowerInstallation.getTowerConnectorStatic(this.towerURL, this.towerCredentialsId, this.towerTrustCert, this.enableDebugging, this.run);
    }

    public static TowerConnector getTowerConnectorStatic(String towerURL, String towerCredentialsId, boolean trustCert, boolean enableDebugging, Run run) {
        String username = null;
        String password = null;
        String oauth_token = null;
        if (StringUtils.isNotBlank((String)towerCredentialsId)) {
            List<StandardUsernamePasswordCredentials> credsList = TowerInstallation.getCredsList(StandardUsernamePasswordCredentials.class, run);
            for (StandardUsernamePasswordCredentials creds : credsList) {
                if (!creds.getId().equals(towerCredentialsId)) continue;
                username = creds.getUsername();
                password = creds.getPassword().getPlainText();
            }
            List<StringCredentials> secretList = TowerInstallation.getCredsList(StringCredentials.class, run);
            for (StringCredentials secret : secretList) {
                if (!secret.getId().equals(towerCredentialsId)) continue;
                oauth_token = secret.getSecret().getPlainText();
            }
        }
        TowerConnector testConnector = new TowerConnector(towerURL, username, password, oauth_token, trustCert, enableDebugging);
        return testConnector;
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private static <C extends Credentials> List<C> getCredsList(Class<C> type, Run run) {
        List credsList = run != null && run.getParent() != null ? CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), null, (DomainRequirement[])new DomainRequirement[]{new DomainRequirement()}) : CredentialsProvider.lookupCredentials(type);
        return credsList;
    }

    @Extension
    public static class TowerInstallationDescriptor
    extends Descriptor<TowerInstallation> {
        @POST
        public FormValidation doTestTowerConnection(@QueryParameter(value="towerURL") String towerURL, @QueryParameter(value="towerCredentialsId") String towerCredentialsId, @QueryParameter(value="towerTrustCert") boolean towerTrustCert, @QueryParameter(value="enableDebugging") boolean enableDebugging) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            TowerLogger.writeMessage("Starting to test connection with (" + towerURL + ") and (" + towerCredentialsId + ") and (" + towerTrustCert + ") with debugging (" + enableDebugging + ")");
            TowerConnector testConnector = TowerInstallation.getTowerConnectorStatic(towerURL, towerCredentialsId, towerTrustCert, enableDebugging, null);
            try {
                testConnector.testConnection();
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Project project) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project)).withMatching(CredentialsMatchers.instanceOf(StringCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)project));
        }

        public String getDisplayName() {
            return "Tower Installation";
        }
    }
}

