/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower.util;

import java.io.IOException;
import java.io.Serializable;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerException;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerItemDoesNotExist;
import org.jenkinsci.plugins.ansible_tower.util.TowerConnector;
import org.jenkinsci.plugins.ansible_tower.util.TowerProjectSync;

public class TowerProject
implements Serializable {
    String projectName;
    String apiEndPoint = "/projects/";
    String projectID = "";
    TowerConnector myConnector = null;
    JSONObject projectData = null;
    JSONObject updateResponse = null;

    public TowerProject(String projectName, TowerConnector myConnector) throws AnsibleTowerException {
        HttpResponse response;
        this.projectName = projectName;
        this.myConnector = myConnector;
        if (projectName == null || projectName.isEmpty()) {
            throw new AnsibleTowerException("Template can not be null");
        }
        try {
            this.projectID = myConnector.convertPotentialStringToID(projectName, this.apiEndPoint);
        }
        catch (AnsibleTowerItemDoesNotExist atidne) {
            throw new AnsibleTowerException("Project " + projectName + " does not exist in tower");
        }
        catch (AnsibleTowerException ate) {
            throw new AnsibleTowerException("Unable to find project " + projectName + ": " + ate.getMessage());
        }
        try {
            response = myConnector.makeRequest(1, this.apiEndPoint + this.projectID + "/", null, false);
        }
        catch (AnsibleTowerException e) {
            throw new AnsibleTowerException("Failed to load project information for " + projectName + ": " + e.getMessage());
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned when getting project (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            this.projectData = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read project response and convert it into json: " + ioe.getMessage());
        }
    }

    public String getProjectSyncURL() {
        return this.projectData.getJSONObject("related").getString("update");
    }

    public boolean canUpdate() throws AnsibleTowerException {
        if (this.updateResponse == null) {
            if (!this.projectData.containsKey((Object)"related") || !this.projectData.getJSONObject("related").containsKey((Object)"update")) {
                return false;
            }
            HttpResponse response = this.myConnector.makeRequest(1, this.projectData.getJSONObject("related").getString("update"), null, false);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new AnsibleTowerException("Unexpected error code return when getting project update (" + response.getStatusLine().getStatusCode() + ")");
            }
            try {
                this.updateResponse = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException ioe) {
                throw new AnsibleTowerException("Unable to read project update response and convert it into json: " + ioe.getMessage());
            }
        }
        return this.updateResponse.getBoolean("can_update");
    }

    public boolean updateRevision(String revision) throws AnsibleTowerException {
        HttpResponse response;
        String finalEndPoint = this.apiEndPoint + this.projectID + "/";
        JSONObject patchBody = new JSONObject();
        patchBody.put("scm_branch", (Object)revision);
        try {
            response = this.myConnector.makeRequest(3, finalEndPoint, patchBody, false);
        }
        catch (AnsibleTowerException e) {
            throw new AnsibleTowerException("Failed to update project revision for " + this.projectName + ": " + e.getMessage());
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected response code returned when updating project (" + response.getStatusLine().getStatusCode() + ")");
        }
        return true;
    }

    public TowerProjectSync sync() throws AnsibleTowerException {
        TowerProjectSync mySync = new TowerProjectSync(this.myConnector, this);
        return mySync;
    }

    public void releaseToken() throws AnsibleTowerException {
        this.myConnector.releaseToken();
    }
}

