/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.ansible_tower.exceptions.AnsibleTowerException;
import org.jenkinsci.plugins.ansible_tower.util.TowerConnector;
import org.jenkinsci.plugins.ansible_tower.util.TowerProject;

public class TowerProjectSync
implements Serializable {
    private TowerConnector connection = null;
    private TowerProject projectReference = null;
    private JSONObject syncData = null;
    private long lastLogId = 0L;

    public TowerProjectSync(TowerConnector connection, TowerProject projectReference) throws AnsibleTowerException {
        this.connection = connection;
        this.projectReference = projectReference;
        HttpResponse response = connection.makeRequest(2, projectReference.getProjectSyncURL(), null, false);
        if (response.getStatusLine().getStatusCode() != 202 && response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned when launching project sync (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            this.syncData = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read project sync launch response and convert it into json: " + ioe.getMessage());
        }
    }

    private void loadSync(int method) throws AnsibleTowerException {
        HttpResponse response = this.connection.makeRequest(method, this.syncData.getString("url"), null, false);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AnsibleTowerException("Unexpected error code returned when loading project sync (" + response.getStatusLine().getStatusCode() + ")");
        }
        try {
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            this.syncData = JSONObject.fromObject((Object)json);
        }
        catch (IOException ioe) {
            throw new AnsibleTowerException("Unable to read project sync response and convert it into json: " + ioe.getMessage());
        }
    }

    public boolean isComplete() throws AnsibleTowerException {
        this.loadSync(1);
        return this.syncData.containsKey((Object)"finished") && this.syncData.getString("finished") != null && !this.syncData.getString("finished").equalsIgnoreCase("null");
    }

    public boolean wasSuccessful() throws AnsibleTowerException {
        this.loadSync(1);
        if (this.syncData.containsKey((Object)"failed")) {
            return !this.syncData.getBoolean("failed");
        }
        throw new AnsibleTowerException("Did not get a failed status from project sync!");
    }

    public Vector<String> getLogs() throws AnsibleTowerException {
        Vector<String> events = new Vector<String>();
        boolean keepChecking = true;
        while (keepChecking) {
            String apiURL = this.syncData.getJSONObject("related").getString("events") + "?id__gt=" + this.lastLogId;
            HttpResponse response = this.connection.makeRequest(1, apiURL, null, false);
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject responseObject;
                try {
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    responseObject = JSONObject.fromObject((Object)json);
                }
                catch (IOException ioe) {
                    throw new AnsibleTowerException("Unable to read project sync event response and convert it into json: " + ioe.getMessage());
                }
                if (responseObject.containsKey((Object)"next") && responseObject.getString("next") == null || responseObject.getString("next").equalsIgnoreCase("null")) {
                    keepChecking = false;
                }
                if (!responseObject.containsKey((Object)"results")) continue;
                for (Object anEvent : responseObject.getJSONArray("results")) {
                    long eventId = ((JSONObject)anEvent).getLong("id");
                    String stdOut = ((JSONObject)anEvent).getString("stdout");
                    events.addAll(this.connection.logLine(stdOut));
                    if (eventId <= this.lastLogId) continue;
                    this.lastLogId = eventId;
                }
                continue;
            }
            throw new AnsibleTowerException("Unexpected error code returned when getting project sync events (" + response.getStatusLine().getStatusCode() + ")");
        }
        return events;
    }

    public void cancelSync() throws AnsibleTowerException {
        HttpResponse response = this.connection.makeRequest(2, this.syncData.getJSONObject("related").getString("cancel"), null, false);
        this.connection.releaseToken();
        if (response.getStatusLine().getStatusCode() != 202 && response.getStatusLine().getStatusCode() != 405) {
            throw new AnsibleTowerException("Unexpected response code from project sync cancel (" + response.getStatusLine().getStatusCode() + ")");
        }
    }

    public String getURL() {
        return this.connection.getURL() + "/#/jobs/project/" + this.syncData.getLong("id");
    }

    public long getID() {
        return this.syncData.getLong("id");
    }

    public void releaseToken() throws AnsibleTowerException {
        this.connection.releaseToken();
    }
}

