/*
 * Decompiled with CFR 0.152.
 */
package jenkins.authentication.tokens.api;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.When;
import hudson.ExtensionPoint;
import jenkins.authentication.tokens.api.AuthenticationTokenException;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticationTokenSource<T, C extends Credentials>
implements ExtensionPoint {
    private final Class<T> tokenClass;
    private final Class<C> credentialsClass;

    protected AuthenticationTokenSource(Class<T> tokenClass, Class<C> credentialsClass) {
        this.tokenClass = tokenClass;
        this.credentialsClass = credentialsClass;
    }

    @NonNull
    public abstract T convert(@NonNull C var1) throws AuthenticationTokenException;

    @NonNull
    @OverrideMustInvoke(value=When.ANYTIME)
    public CredentialsMatcher matcher() {
        return CredentialsMatchers.instanceOf(this.credentialsClass);
    }

    public final <T> boolean produces(@NonNull Class<T> tokenClass) {
        return tokenClass.isAssignableFrom(this.tokenClass);
    }

    public final <C extends Credentials> boolean consumes(@NonNull Class<C> credentialsClass) {
        return this.credentialsClass.isAssignableFrom(credentialsClass);
    }

    public final boolean consumes(@NonNull Credentials credentials) {
        return this.credentialsClass.isInstance(credentials) && this.matcher().matches(credentials);
    }

    final Integer score(Class<?> tokenClass, Credentials credentials) {
        if (!this.produces(tokenClass) || !this.consumes(credentials)) {
            return null;
        }
        int producerScore = this.tokenClass.equals(tokenClass) ? Short.MAX_VALUE : (this.tokenClass.isInterface() ? 0 : (int)((short)ClassUtils.getAllSuperclasses(tokenClass).indexOf(this.tokenClass)));
        int consumerScore = this.credentialsClass.equals(credentials.getClass()) ? Short.MAX_VALUE : (this.credentialsClass.isInterface() ? 0 : (int)((short)ClassUtils.getAllSuperclasses(credentials.getClass()).indexOf(this.credentialsClass)));
        return producerScore << 16 | consumerScore;
    }
}

