/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AmazonWebServicesCredentialsBinding
extends MultiBinding<AmazonWebServicesCredentials> {
    public static final String DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME = "AWS_ACCESS_KEY_ID";
    private static final String DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME = "AWS_SECRET_ACCESS_KEY";
    private static final String SESSION_TOKEN_VARIABLE_NAME = "AWS_SESSION_TOKEN";
    @NonNull
    private final String accessKeyVariable;
    @NonNull
    private final String secretKeyVariable;
    private String roleArn;
    private String roleSessionName;
    private int roleSessionDurationSeconds;

    @DataBoundConstructor
    public AmazonWebServicesCredentialsBinding(@Nullable String accessKeyVariable, @Nullable String secretKeyVariable, String credentialsId) {
        super(credentialsId);
        this.accessKeyVariable = StringUtils.defaultIfBlank((String)accessKeyVariable, (String)DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME);
        this.secretKeyVariable = StringUtils.defaultIfBlank((String)secretKeyVariable, (String)DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME);
    }

    @NonNull
    public String getAccessKeyVariable() {
        return this.accessKeyVariable;
    }

    @NonNull
    public String getSecretKeyVariable() {
        return this.secretKeyVariable;
    }

    @DataBoundSetter
    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    @DataBoundSetter
    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    @DataBoundSetter
    public void setRoleSessionDurationSeconds(int roleSessionDurationSeconds) {
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
    }

    protected Class<AmazonWebServicesCredentials> type() {
        return AmazonWebServicesCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@Nonnull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        AWSCredentialsProvider provider = (AWSCredentialsProvider)this.getCredentials(build);
        if (!StringUtils.isEmpty((String)this.roleArn)) {
            provider = this.assumeRoleProvider(provider);
        }
        AWSCredentials credentials = provider.getCredentials();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(this.accessKeyVariable, credentials.getAWSAccessKeyId());
        m.put(this.secretKeyVariable, credentials.getAWSSecretKey());
        if (credentials instanceof AWSSessionCredentials) {
            m.put(SESSION_TOKEN_VARIABLE_NAME, ((AWSSessionCredentials)credentials).getSessionToken());
        }
        return new MultiBinding.MultiEnvironment(m);
    }

    private AWSSessionCredentialsProvider assumeRoleProvider(AWSCredentialsProvider baseProvider) {
        AWSSecurityTokenService stsClient = AWSCredentialsImpl.buildStsClient(baseProvider);
        String roleSessionName = StringUtils.defaultIfBlank((String)this.roleSessionName, (String)"Jenkins");
        STSAssumeRoleSessionCredentialsProvider.Builder assumeRoleProviderBuilder = new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleArn, roleSessionName).withStsClient(stsClient);
        if (this.roleSessionDurationSeconds > 0) {
            assumeRoleProviderBuilder = assumeRoleProviderBuilder.withRoleSessionDurationSeconds(this.roleSessionDurationSeconds);
        }
        return assumeRoleProviderBuilder.build();
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.accessKeyVariable, this.secretKeyVariable, SESSION_TOKEN_VARIABLE_NAME));
    }

    @Symbol(value={"aws"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AmazonWebServicesCredentials> {
        protected Class<AmazonWebServicesCredentials> type() {
            return AmazonWebServicesCredentials.class;
        }

        public String getDisplayName() {
            return "AWS access key and secret";
        }

        public boolean requiresWorkspace() {
            return false;
        }
    }
}

