/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.Comparator;
import jenkins.model.Jenkins;

public class DescriptorOrder<T extends Describable<T>>
implements Comparator<T> {
    private final DescriptorExtensionList<T, Descriptor<T>> descriptors;

    public static <T extends Describable<T>> Comparator<T> forward(Class<T> type) {
        return new DescriptorOrder<T>(type);
    }

    public static <T extends Describable<T>> Comparator<T> reverse(Class<T> type) {
        return Collections.reverseOrder(DescriptorOrder.forward(type));
    }

    DescriptorOrder(Class<T> type) {
        this.descriptors = Jenkins.get().getDescriptorList(type);
    }

    @Override
    public int compare(T o1, T o2) {
        int i2;
        int i1 = o1 == null ? -1 : this.descriptors.indexOf((Object)o1.getDescriptor());
        int n = i2 = o2 == null ? -1 : this.descriptors.indexOf((Object)o2.getDescriptor());
        if (i1 == -1) {
            return i2 == -1 ? 0 : 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return Integer.compare(i1, i2);
    }
}

