/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import jenkins.branch.Messages;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

public enum MultiBranchProjectDisplayNamingStrategy {
    OBJECT_DISPLAY_NAME(true, Messages._MultiBranchProjectDisplayNamingTrait_DisplayName()){

        @Override
        public String generateName(@NonNull String rawName, String displayName) {
            return StringUtils.isBlank((String)displayName) ? rawName : displayName;
        }
    }
    ,
    RAW_AND_OBJECT_DISPLAY_NAME(true, Messages._MultiBranchProjectDisplayNamingTrait_RawAndDisplayName()){

        @Override
        public String generateName(@NonNull String rawName, String displayName) {
            if (StringUtils.isBlank((String)displayName)) {
                return rawName;
            }
            if (Objects.equals(rawName, displayName)) {
                return rawName;
            }
            Object cleanedUpBranchName = rawName;
            if (((String)cleanedUpBranchName).startsWith("MR-") || ((String)cleanedUpBranchName).startsWith("PR-")) {
                cleanedUpBranchName = "#" + ((String)cleanedUpBranchName).substring(3);
            }
            return String.format("%s (%s)", displayName, cleanedUpBranchName);
        }
    }
    ,
    RAW(true, Messages._MultiBranchProjectDisplayNamingTrait_Raw()){

        @Override
        public String generateName(@NonNull String rawName, String displayName) {
            return rawName;
        }
    };

    private final boolean needsObjectDisplayName;
    private final Localizable displayName;

    private MultiBranchProjectDisplayNamingStrategy(boolean needsObjectDisplayName, Localizable displayName) {
        this.needsObjectDisplayName = needsObjectDisplayName;
        this.displayName = displayName;
    }

    public boolean needsObjectDisplayName() {
        return this.needsObjectDisplayName;
    }

    public String getDisplayName() {
        return this.displayName.toString();
    }

    public abstract String generateName(@NonNull String var1, String var2);
}

