/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.EventOutputStreams;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.PeriodicFolderTrigger;
import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import com.thoughtworks.xstream.XStreamException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import hudson.util.StreamTaskListener;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.BranchEventCause;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.Messages;
import jenkins.branch.MetadataActionFolderIcon;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactory;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.branch.NameEncoder;
import jenkins.branch.NameMangler;
import jenkins.branch.OrganizationChildOrphanedItemsProperty;
import jenkins.branch.OrganizationChildTriggersProperty;
import jenkins.branch.OrganizationFolderEmptyView;
import jenkins.branch.OrganizationFolderProperty;
import jenkins.branch.OrganizationFolderViewHolder;
import jenkins.branch.ProjectNameProperty;
import jenkins.branch.PropertyMigration;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

public final class OrganizationFolder
extends ComputedFolder<MultiBranchProject<?, ?>>
implements SCMNavigatorOwner,
IconSpec {
    private static final Logger LOGGER = Logger.getLogger(OrganizationFolder.class.getName());
    static final String COMPLETED_PROCESSING_EVENT = "[%tc] Finished processing %s %s event from %s with timestamp %tc, processed in %dms. Matched %d.%n";
    private final DescribableList<SCMNavigator, SCMNavigatorDescriptor> navigators = new DescribableList((Saveable)this);
    private final DescribableList<MultiBranchProjectFactory, MultiBranchProjectFactoryDescriptor> projectFactories = new DescribableList((Saveable)this);
    private DescribableList<BranchBuildStrategy, BranchBuildStrategyDescriptor> buildStrategies = new DescribableList((Saveable)this);
    private BranchPropertyStrategy strategy;
    private transient State state = new State(this);
    private transient String navDigest;
    private transient String facDigest;
    private transient String propsDigest;
    private transient String bbsDigest;
    private static final Set<Permission> SUPPRESSED_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Item.CONFIGURE, Item.DELETE, View.CONFIGURE, View.CREATE, View.DELETE)));

    public OrganizationFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        if (this.projectFactories.isEmpty()) {
            for (MultiBranchProjectFactoryDescriptor d : ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class)) {
                MultiBranchProjectFactory f = d.newInstance();
                if (f == null) continue;
                this.projectFactories.add((Object)f);
            }
        }
        this.addTrigger((Trigger)new PeriodicFolderTrigger("1d"));
        try {
            this.addProperty(OrganizationChildTriggersProperty.newDefaultInstance());
            this.addProperty(OrganizationChildOrphanedItemsProperty.newDefaultInstance());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.navigators.setOwner((Saveable)this);
        this.projectFactories.setOwner((Saveable)this);
        if (this.buildStrategies == null) {
            this.buildStrategies = new DescribableList((Saveable)this);
        } else {
            this.buildStrategies.setOwner((Saveable)this);
        }
        if (!(this.getFolderViews() instanceof OrganizationFolderViewHolder)) {
            this.resetFolderViews();
        }
        if (this.getIcon() == null) {
            this.setIcon(this.newDefaultFolderIcon());
        }
        if (this.getProperties().get(OrganizationChildTriggersProperty.class) == null) {
            try {
                this.addProperty(OrganizationChildTriggersProperty.newDefaultInstance());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.getProperties().get(OrganizationChildOrphanedItemsProperty.class) == null) {
            try {
                this.addProperty(OrganizationChildOrphanedItemsProperty.newDefaultInstance());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        PropertyMigration.applyAll(this);
        if (this.state == null) {
            this.state = new State(this);
        }
        try {
            this.state.load();
        }
        catch (XStreamException | IOException e) {
            LOGGER.log(Level.WARNING, "Could not read persisted state, will be recovered on next index.", e);
            this.state.reset();
        }
        if (this.getComputation().getLogFile().isFile()) {
            try {
                this.navDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.navigators));
            }
            catch (XStreamException e) {
                this.navDigest = null;
            }
            try {
                this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.projectFactories));
            }
            catch (XStreamException e) {
                this.facDigest = null;
            }
            try {
                this.propsDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.strategy));
            }
            catch (XStreamException e) {
                this.propsDigest = null;
            }
            try {
                this.bbsDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.buildStrategies));
            }
            catch (XStreamException e) {
                this.bbsDigest = null;
            }
        }
    }

    public MultiBranchProject<?, ?> getItem(String name) throws AccessDeniedException {
        String decoded;
        if (name == null) {
            return null;
        }
        MultiBranchProject item = (MultiBranchProject)super.getItem(name);
        if (item != null) {
            return item;
        }
        if (name.indexOf(37) != -1 && (item = (MultiBranchProject)super.getItem(decoded = NameEncoder.decode(name))) != null) {
            return item;
        }
        return (MultiBranchProject)super.getItem(NameEncoder.encode(name));
    }

    @CheckForNull
    public MultiBranchProject<?, ?> getItemByProjectName(@NonNull String projectName) {
        return (MultiBranchProject)super.getItem(NameEncoder.encode(projectName));
    }

    @Deprecated
    public boolean isSingleOrigin() {
        return this.navigators.size() == 1;
    }

    public DescribableList<SCMNavigator, SCMNavigatorDescriptor> getNavigators() {
        return this.navigators;
    }

    @NonNull
    public List<SCMNavigator> getSCMNavigators() {
        return this.navigators;
    }

    public DescribableList<MultiBranchProjectFactory, MultiBranchProjectFactoryDescriptor> getProjectFactories() {
        return this.projectFactories;
    }

    public BranchPropertyStrategy getStrategy() {
        return this.strategy != null ? this.strategy : new DefaultBranchPropertyStrategy(new BranchProperty[0]);
    }

    public void setStrategy(BranchPropertyStrategy strategy) {
        this.strategy = strategy;
    }

    public DescribableList<BranchBuildStrategy, BranchBuildStrategyDescriptor> getBuildStrategies() {
        return this.buildStrategies;
    }

    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        String bbsDigest;
        String propsDigest;
        String facDigest;
        String navDigest;
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.navigators.rebuildHetero(req, json, (Collection)ExtensionList.lookup(SCMNavigatorDescriptor.class), "navigators");
        this.projectFactories.rebuildHetero(req, json, (Collection)ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class), "projectFactories");
        this.buildStrategies.rebuildHetero(req, json, (Collection)ExtensionList.lookup(BranchBuildStrategyDescriptor.class), "buildStrategies");
        this.strategy = (BranchPropertyStrategy)((Object)req.bindJSON(BranchPropertyStrategy.class, json.getJSONObject("strategy")));
        for (SCMNavigator n : this.navigators) {
            n.afterSave((SCMNavigatorOwner)this);
        }
        try {
            navDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.navigators));
        }
        catch (XStreamException e) {
            navDigest = null;
        }
        try {
            facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.projectFactories));
        }
        catch (XStreamException e) {
            facDigest = null;
        }
        try {
            propsDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.strategy));
        }
        catch (XStreamException e) {
            propsDigest = null;
        }
        try {
            bbsDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.buildStrategies));
        }
        catch (XStreamException e) {
            bbsDigest = null;
        }
        this.recalculateAfterSubmitted(!StringUtils.equals((String)navDigest, (String)this.navDigest));
        this.recalculateAfterSubmitted(!StringUtils.equals((String)facDigest, (String)this.facDigest));
        this.recalculateAfterSubmitted(!StringUtils.equals((String)propsDigest, (String)this.propsDigest));
        this.recalculateAfterSubmitted(!StringUtils.equals((String)bbsDigest, (String)this.bbsDigest));
        this.navDigest = navDigest;
        this.facDigest = facDigest;
        this.propsDigest = propsDigest;
        this.bbsDigest = bbsDigest;
    }

    @NonNull
    protected FolderComputation<MultiBranchProject<?, ?>> createComputation(@CheckForNull FolderComputation<MultiBranchProject<?, ?>> previous) {
        return new OrganizationScan(this, previous);
    }

    public boolean isHasEvents() {
        return true;
    }

    public boolean isBuildable() {
        return super.isBuildable() && !this.navigators.isEmpty() && !this.projectFactories.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void computeChildren(ChildObserver<MultiBranchProject<?, ?>> observer, TaskListener listener) throws IOException, InterruptedException {
        block25: {
            try {
                this.navDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.navigators));
            }
            catch (XStreamException e) {
                this.navDigest = null;
            }
            try {
                this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.projectFactories));
            }
            catch (XStreamException e) {
                this.facDigest = null;
            }
            try {
                this.bbsDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.buildStrategies));
            }
            catch (XStreamException e) {
                this.bbsDigest = null;
            }
            start = System.currentTimeMillis();
            listener.getLogger().format("[%tc] Starting organization scan...%n", new Object[]{start});
            try {
                listener.getLogger().format("[%tc] Updating actions...%n", new Object[]{System.currentTimeMillis()});
                navigatorActions = new HashMap<SCMNavigator, List<Action>>();
                for (Object navigator : this.navigators) {
                    try {
                        actions = navigator.fetchActions((SCMNavigatorOwner)this, null, listener);
                    }
                    catch (IOException e) {
                        Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("[%tc] Could not refresh actions for navigator %s", new Object[]{System.currentTimeMillis(), navigator}));
                        actions = Util.fixNull(this.state.getActions().get(navigator));
                    }
                    navigatorActions.put((SCMNavigator)navigator, actions);
                }
                if (navigatorActions.equals(this.state.getActions())) ** GOTO lbl62
                saveProject = false;
                navigator = navigatorActions.values().iterator();
                while (true) {
                    block26: {
                        if (navigator.hasNext()) {
                            actions = (List)navigator.next();
                            var9_18 = actions.iterator();
                            break block25;
                        }
                        bc = new BulkChange((Saveable)this.state);
                        try {
                            this.state.setActions(navigatorActions);
                            try {
                                bc.commit();
                            }
                            catch (IOException | RuntimeException e) {
                                listener.error("[%tc] Could not persist folder level actions", new Object[]{System.currentTimeMillis()});
                                throw e;
                            }
                            if (!saveProject) break block26;
                            try {
                                this.save();
                            }
                            catch (IOException | RuntimeException e) {
                                listener.error("[%tc] Could not persist folder level configuration changes", new Object[]{System.currentTimeMillis()});
                                throw e;
                            }
                        }
                        finally {
                            bc.abort();
                        }
                    }
                    for (Object navigator : this.navigators) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        listener.getLogger().format("[%tc] Consulting %s%n", new Object[]{System.currentTimeMillis(), navigator.getDescriptor().getDisplayName()});
                        try {
                            navigator.visitSources((SCMSourceObserver)new SCMSourceObserverImpl(listener, observer, (SCMNavigator)navigator, null));
                        }
                        catch (IOException | InterruptedException | RuntimeException e) {
                            listener.error("[%tc] Could not fetch sources from navigator %s", new Object[]{System.currentTimeMillis(), navigator});
                            throw e;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var12_21) {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished organization scan. Scan took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                throw var12_21;
            }
            {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished organization scan. Scan took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                return;
            }
        }
        while (true) {
            if (!var9_18.hasNext()) ** continue;
            a = (Action)var9_18.next();
            saveProject = this.removeActions(a.getClass()) != false || saveProject != false;
        }
    }

    protected AbstractFolderViewHolder newFolderViewHolder() {
        return new OrganizationFolderViewHolder(this);
    }

    protected FolderIcon newDefaultFolderIcon() {
        return new MetadataActionFolderIcon();
    }

    public String getIconClassName() {
        String result;
        if (this.navigators.size() == 1) {
            result = ((SCMNavigator)this.navigators.get(0)).getDescriptor().getIconClassName();
        } else {
            result = null;
            for (int i = 0; i < this.navigators.size(); ++i) {
                String iconClassName = ((SCMNavigator)this.navigators.get(i)).getDescriptor().getIconClassName();
                if (i == 0) {
                    result = iconClassName;
                    continue;
                }
                if (StringUtils.equals((String)result, (String)iconClassName)) continue;
                result = null;
                break;
            }
        }
        return result != null ? result : this.getDescriptor().getIconClassName();
    }

    public String getSourcePronoun() {
        TreeSet<String> result = new TreeSet<String>();
        for (SCMNavigator navigator : this.navigators) {
            String pronoun = Util.fixEmptyAndTrim((String)navigator.getPronoun());
            if (pronoun == null) continue;
            result.add(pronoun);
        }
        return result.isEmpty() ? this.getPronoun() : StringUtils.join(result, (String)" / ");
    }

    @NonNull
    public List<SCMSource> getSCMSources() {
        HashSet<SCMSource> result = new HashSet<SCMSource>();
        for (MultiBranchProject child : this.getItems(MultiBranchProject::isBuildable)) {
            result.addAll(child.getSCMSources());
        }
        return new ArrayList<SCMSource>(result);
    }

    public SCMSource getSCMSource(String sourceId) {
        return null;
    }

    public void onSCMSourceUpdated(@NonNull SCMSource source) {
    }

    public SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return null;
    }

    public View getPrimaryView() {
        if (!this.hasVisibleItems()) {
            return this.getWelcomeView();
        }
        return super.getPrimaryView();
    }

    protected View getWelcomeView() {
        return new OrganizationFolderEmptyView((ViewGroup)this);
    }

    public View getView(String name) {
        if (name.equals("Welcome")) {
            return this.getWelcomeView();
        }
        return super.getView(name);
    }

    public String getDescription() {
        String description = super.getDescription();
        if (StringUtils.isNotBlank((String)description)) {
            return description;
        }
        ObjectMetadataAction action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class);
        if (action != null) {
            return action.getObjectDescription();
        }
        return super.getDescription();
    }

    public String getDisplayName() {
        ObjectMetadataAction action;
        String displayName = this.getDisplayNameOrNull();
        if (displayName == null && (action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class)) != null && StringUtils.isNotBlank((String)action.getObjectDisplayName())) {
            return action.getObjectDisplayName();
        }
        return super.getDisplayName();
    }

    @NonNull
    public ACL getACL() {
        final ACL acl = super.getACL();
        if (this.getParent() instanceof ComputedFolder) {
            return new ACL(){

                public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                    if (ACL.SYSTEM2.equals(a)) {
                        return true;
                    }
                    if (SUPPRESSED_PERMISSIONS.contains(permission)) {
                        return false;
                    }
                    return acl.hasPermission2(a, permission);
                }
            };
        }
        return acl;
    }

    static /* synthetic */ ChildObserver access$000(OrganizationFolder x0) {
        return x0.openEventsChildObserver();
    }

    static /* synthetic */ ChildObserver access$100(OrganizationFolder x0) {
        return x0.openEventsChildObserver();
    }

    private static class State
    implements Saveable {
        private final transient OrganizationFolder owner;
        private final Map<String, List<Action>> actions = new HashMap<String, List<Action>>();

        private State(OrganizationFolder owner) {
            this.owner = owner;
        }

        public synchronized void reset() {
            this.actions.clear();
        }

        public final XmlFile getStateFile() {
            return new XmlFile(Items.XSTREAM, new File(this.owner.getRootDir(), "state.xml"));
        }

        public synchronized void load() throws IOException {
            if (this.getStateFile().exists()) {
                this.getStateFile().unmarshal((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            State state = this;
            synchronized (state) {
                if (BulkChange.contains((Saveable)this)) {
                    return;
                }
                this.getStateFile().write((Object)this);
            }
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getStateFile());
        }

        public List<Action> getActions(SCMNavigator navigator) {
            if (this.owner.getSCMNavigators().contains(navigator)) {
                return Collections.unmodifiableList(Util.fixNull(this.actions.get(navigator.getId())));
            }
            return null;
        }

        public void setActions(SCMNavigator navigator, List<Action> actions) {
            this.actions.put(navigator.getId(), new ArrayList<Action>(actions));
        }

        public Map<SCMNavigator, List<Action>> getActions() {
            List<SCMNavigator> navigators = this.owner.getSCMNavigators();
            HashMap<SCMNavigator, List<Action>> result = new HashMap<SCMNavigator, List<Action>>(navigators.size());
            for (SCMNavigator navigator : navigators) {
                result.put(navigator, Collections.unmodifiableList(Util.fixNull(this.actions.get(navigator.getId()))));
            }
            return result;
        }

        public void setActions(Map<SCMNavigator, List<Action>> actions) {
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry<SCMNavigator, List<Action>> entry : actions.entrySet()) {
                String id = entry.getKey().getId();
                this.actions.put(id, new ArrayList(Util.fixNull(entry.getValue())));
                keys.add(id);
            }
            this.actions.keySet().retainAll(keys);
        }
    }

    public static class OrganizationScan
    extends FolderComputation<MultiBranchProject<?, ?>> {
        public OrganizationScan(OrganizationFolder folder, FolderComputation<MultiBranchProject<?, ?>> previous) {
            super((ComputedFolder)folder, previous);
        }

        public String getDisplayName() {
            return Messages.OrganizationFolder_OrganizationScan_displayName(((OrganizationFolder)this.getParent()).getSourcePronoun());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "{0} #{1,time,yyyyMMdd.HHmmss} organization scan action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
                throw throwable;
            }
            long end = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "{0} #{1,time,yyyyMMdd.HHmmss} organization scan action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
        }
    }

    private class SCMSourceObserverImpl
    extends SCMSourceObserver {
        private final TaskListener listener;
        private final ChildObserver<MultiBranchProject<?, ?>> observer;
        private final SCMEvent<?> event;
        private final SCMNavigator navigator;

        public SCMSourceObserverImpl(TaskListener listener, ChildObserver<MultiBranchProject<?, ?>> observer, SCMNavigator navigator, SCMEvent<?> event) {
            this.listener = listener;
            this.observer = observer;
            this.navigator = navigator;
            this.event = event;
        }

        @NonNull
        public SCMSourceOwner getContext() {
            return OrganizationFolder.this;
        }

        @NonNull
        public TaskListener getListener() {
            return this.listener;
        }

        @NonNull
        public SCMSourceObserver.ProjectObserver observe(final @NonNull String projectName) {
            return new SCMSourceObserver.ProjectObserver(){
                List<SCMSource> sources = new ArrayList<SCMSource>();

                public void addSource(@NonNull SCMSource source) {
                    this.sources.add(source);
                    source.setOwner((SCMSourceOwner)OrganizationFolder.this);
                }

                private List<BranchSource> createBranchSources() {
                    if (this.sources == null) {
                        throw new IllegalStateException();
                    }
                    ArrayList<BranchSource> branchSources = new ArrayList<BranchSource>();
                    for (SCMSource source : this.sources) {
                        BranchSource branchSource = new BranchSource(source);
                        branchSource.setBuildStrategies((List<BranchBuildStrategy>)OrganizationFolder.this.buildStrategies);
                        branchSource.setStrategy(OrganizationFolder.this.strategy);
                        branchSources.add(branchSource);
                    }
                    return branchSources;
                }

                public void addAttribute(@NonNull String key, Object value) throws IllegalArgumentException, ClassCastException {
                    throw new IllegalArgumentException();
                }

                private boolean recognizes(Map<String, Object> attributes, MultiBranchProjectFactory candidateFactory) throws IOException, InterruptedException {
                    return candidateFactory.recognizes((ItemGroup<?>)OrganizationFolder.this, projectName, (List<? extends SCMSource>)this.sources, attributes, (SCMHeadEvent<?>)(SCMSourceObserverImpl.this.event instanceof SCMHeadEvent ? (SCMHeadEvent)SCMSourceObserverImpl.this.event : null), SCMSourceObserverImpl.this.listener);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete() throws IllegalStateException, IOException, InterruptedException {
                    try {
                        MultiBranchProjectFactory factory = null;
                        Map<String, Object> attributes = Collections.emptyMap();
                        for (MultiBranchProjectFactory candidateFactory : OrganizationFolder.this.projectFactories) {
                            boolean recognizes = this.recognizes(attributes, candidateFactory);
                            LOGGER.fine(() -> candidateFactory + " recognizes " + projectName + " with " + attributes + "? " + recognizes);
                            if (!recognizes) continue;
                            factory = candidateFactory;
                            break;
                        }
                        if (factory == null) {
                            return;
                        }
                        String folderName = NameEncoder.encode(projectName);
                        MultiBranchProject existing = (MultiBranchProject)((Object)OrganizationFolder.this.items.get(folderName));
                        boolean wasBuildable = existing != null && existing.isBuildable();
                        boolean wasDisabled = existing != null && existing.isDisabled();
                        existing = (MultiBranchProject)SCMSourceObserverImpl.this.observer.shouldUpdate(folderName);
                        try {
                            if (existing != null) {
                                this.completeExisting(factory, attributes, existing, wasBuildable, wasDisabled);
                            } else {
                                this.completeNew(factory, attributes, folderName);
                            }
                        }
                        finally {
                            SCMSourceObserverImpl.this.observer.completed(folderName);
                        }
                    }
                    catch (IOException | InterruptedException x) {
                        throw x;
                    }
                    catch (Exception x) {
                        Functions.printStackTrace((Throwable)x, (PrintWriter)SCMSourceObserverImpl.this.listener.error("Failed to create or update a subproject " + projectName));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void completeExisting(MultiBranchProjectFactory factory, Map<String, Object> attributes, MultiBranchProject<?, ?> existing, boolean wasBuildable, boolean wasDisabled) throws IOException, InterruptedException {
                    BulkChange bc = new BulkChange(existing);
                    try {
                        existing.setSourcesList(this.createBranchSources());
                        factory.updateExistingProject(existing, attributes, SCMSourceObserverImpl.this.listener);
                        ProjectNameProperty property = (ProjectNameProperty)existing.getProperties().get(ProjectNameProperty.class);
                        if (property == null || !projectName.equals(property.getName())) {
                            existing.getProperties().remove(ProjectNameProperty.class);
                            existing.addProperty(new ProjectNameProperty(projectName));
                        }
                        for (AbstractFolderProperty folderProperty : OrganizationFolder.this.getProperties()) {
                            if (!(folderProperty instanceof OrganizationFolderProperty)) continue;
                            ((OrganizationFolderProperty)folderProperty).applyDecoration(existing, SCMSourceObserverImpl.this.listener);
                        }
                    }
                    finally {
                        bc.commit();
                    }
                    existing.fireSCMSourceAfterSave(existing.getSCMSources());
                    if (OrganizationFolder.this.isBuildable() && existing.isBuildable() && (!wasBuildable || wasDisabled || existing.updateDigests())) {
                        existing.scheduleBuild(SCMSourceObserverImpl.this.cause());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void completeNew(MultiBranchProjectFactory factory, Map<String, Object> attributes, String folderName) throws IOException, InterruptedException {
                    MultiBranchProject<?, ?> project;
                    if (!SCMSourceObserverImpl.this.observer.mayCreate(folderName)) {
                        SCMSourceObserverImpl.this.listener.getLogger().println("Ignoring duplicate child " + projectName + " named " + folderName);
                        return;
                    }
                    try (ChildNameGenerator.Trace trace = ChildNameGenerator.beforeCreateItem((AbstractFolder)OrganizationFolder.this, (String)folderName, (String)projectName);){
                        if (OrganizationFolder.this.getItem(folderName) != null) {
                            throw new IllegalStateException("JENKINS-42511: attempted to redundantly create " + folderName + " in " + OrganizationFolder.this);
                        }
                        project = factory.createNewProject((ItemGroup<?>)OrganizationFolder.this, folderName, (List<? extends SCMSource>)this.sources, attributes, SCMSourceObserverImpl.this.listener);
                    }
                    BulkChange bc = new BulkChange(project);
                    try {
                        if (!projectName.equals(folderName)) {
                            project.setDisplayName(projectName);
                        }
                        project.addProperty(new ProjectNameProperty(projectName));
                        project.getSourcesList().addAll(this.createBranchSources());
                        for (AbstractFolderProperty property : OrganizationFolder.this.getProperties()) {
                            if (!(property instanceof OrganizationFolderProperty)) continue;
                            ((OrganizationFolderProperty)property).applyDecoration(project, SCMSourceObserverImpl.this.listener);
                        }
                    }
                    finally {
                        bc.commit();
                    }
                    SCMSourceObserverImpl.this.observer.created(project);
                    project.fireSCMSourceAfterSave(project.getSCMSources());
                    if (OrganizationFolder.this.isBuildable() && project.isBuildable()) {
                        project.scheduleBuild(SCMSourceObserverImpl.this.cause());
                    }
                }
            };
        }

        public void addAttribute(@NonNull String key, Object value) throws IllegalArgumentException, ClassCastException {
            throw new IllegalArgumentException();
        }

        private Cause cause() {
            if (this.event instanceof SCMHeadEvent) {
                return new BranchEventCause(this.event, ((SCMHeadEvent)this.event).descriptionFor(this.navigator));
            }
            if (this.event instanceof SCMSourceEvent) {
                return new BranchEventCause(this.event, ((SCMSourceEvent)this.event).descriptionFor(this.navigator));
            }
            if (this.event instanceof SCMNavigatorEvent) {
                return new BranchEventCause(this.event, ((SCMNavigatorEvent)this.event).descriptionFor(this.navigator));
            }
            if (this.event != null) {
                return new BranchEventCause(this.event, this.event.description());
            }
            return new BranchIndexingCause();
        }
    }

    @Extension
    public static class StateActionFactory
    extends TransientActionFactory<OrganizationFolder> {
        public Class<OrganizationFolder> type() {
            return OrganizationFolder.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull OrganizationFolder target) {
            ArrayList<Action> result = new ArrayList<Action>();
            for (List<Action> actions : target.state.getActions().values()) {
                result.addAll(actions);
            }
            return result;
        }
    }

    @Extension
    public static class SCMEventListenerImpl
    extends SCMEventListener {
        private final EventOutputStreams globalEvents = this.createGlobalEvents();

        private EventOutputStreams createGlobalEvents() {
            File oldFile;
            File eventsFile;
            File logsDir = new File(Jenkins.get().getRootDir(), "logs");
            if (!logsDir.isDirectory() && !logsDir.mkdirs()) {
                LOGGER.log(Level.WARNING, "Could not create logs directory: {0}", logsDir);
            }
            if (!(eventsFile = new File(logsDir, OrganizationFolder.class.getName() + ".log")).isFile() && (oldFile = new File(logsDir.getParent(), eventsFile.getName())).isFile() && !oldFile.renameTo(eventsFile)) {
                FileUtils.deleteQuietly((File)oldFile);
            }
            return new EventOutputStreams(new EventOutputStreams.OutputFile(){

                @NonNull
                public File get() {
                    return eventsFile;
                }
            }, 250L, TimeUnit.MILLISECONDS, 1024, true, 32768L, 5);
        }

        @Restricted(value={NoExternalUse.class})
        public StreamTaskListener globalEventsListener() {
            return new StreamBuildListener(this.globalEvents.get(), StandardCharsets.UTF_8);
        }

        /*
         * Exception decompiling
         */
        public void onSCMHeadEvent(SCMHeadEvent<?> event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void onSCMNavigatorEvent(SCMNavigatorEvent<?> event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void onSCMSourceEvent(SCMSourceEvent<?> event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ChildNameGeneratorImpl
    extends ChildNameGenerator<OrganizationFolder, MultiBranchProject<?, ?>> {
        private static final ChildNameGeneratorImpl INSTANCE = new ChildNameGeneratorImpl();

        private ChildNameGeneratorImpl() {
        }

        @CheckForNull
        public String itemNameFromItem(@NonNull OrganizationFolder parent, @NonNull MultiBranchProject<?, ?> item) {
            ProjectNameProperty property = (ProjectNameProperty)item.getProperties().get(ProjectNameProperty.class);
            if (property != null) {
                return NameEncoder.encode(property.getName());
            }
            String idealName = this.idealNameFromItem((AbstractFolder)parent, (TopLevelItem)item);
            if (idealName != null) {
                return NameEncoder.encode(idealName);
            }
            return null;
        }

        @CheckForNull
        public String dirNameFromItem(@NonNull OrganizationFolder parent, @NonNull MultiBranchProject<?, ?> item) {
            ProjectNameProperty property = (ProjectNameProperty)item.getProperties().get(ProjectNameProperty.class);
            if (property != null) {
                return NameMangler.apply(property.getName());
            }
            String idealName = this.idealNameFromItem((AbstractFolder)parent, (TopLevelItem)item);
            if (idealName != null) {
                return NameMangler.apply(idealName);
            }
            return null;
        }

        @NonNull
        public String itemNameFromLegacy(@NonNull OrganizationFolder parent, @NonNull String legacyDirName) {
            return NameEncoder.decode(legacyDirName);
        }

        @NonNull
        public String dirNameFromLegacy(@NonNull OrganizationFolder parent, @NonNull String legacyDirName) {
            return NameMangler.apply(NameEncoder.decode(legacyDirName));
        }

        public void recordLegacyName(OrganizationFolder parent, MultiBranchProject<?, ?> item, String legacyDirName) throws IOException {
            item.addProperty(new ProjectNameProperty(legacyDirName));
        }
    }

    @Extension
    @Symbol(value={"organizationFolder"})
    public static class DescriptorImpl
    extends AbstractFolderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.OrganizationFolder_DisplayName();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new OrganizationFolder(parent, name);
        }

        @NonNull
        public String getCategoryId() {
            return "nested-projects";
        }

        public List<BranchPropertyStrategyDescriptor> propertyStrategyDescriptors() {
            return BranchPropertyStrategyDescriptor.all();
        }

        @NonNull
        public String getDescription() {
            return Messages.OrganizationFolder_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/branch-api/images/organization-folder.svg";
        }

        public String getIconClassName() {
            return "symbol-business-outline plugin-ionicons-api";
        }

        public List<FolderIconDescriptor> getIconDescriptors() {
            return Collections.singletonList((FolderIconDescriptor)Jenkins.get().getDescriptorByType(MetadataActionFolderIcon.DescriptorImpl.class));
        }

        public boolean isIconConfigurable() {
            return true;
        }

        @NonNull
        public final ChildNameGenerator<OrganizationFolder, ? extends TopLevelItem> childNameGenerator() {
            return ChildNameGeneratorImpl.INSTANCE;
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-branch-api-organization-folder icon-sm", "plugin/branch-api/images/organization-folder.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-branch-api-organization-folder icon-md", "plugin/branch-api/images/organization-folder.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-branch-api-organization-folder icon-lg", "plugin/branch-api/images/organization-folder.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-branch-api-organization-folder icon-xlg", "plugin/branch-api/images/organization-folder.svg", "width: 48px; height: 48px;"));
        }
    }
}

