/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Stapler;

public class BitbucketLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;

    public BitbucketLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getIconClassName() {
        return this.iconClassName;
    }

    public String getIconFileName() {
        Icon icon;
        String iconClassName = this.getIconClassName();
        if (iconClassName != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.BitbucketLink_DisplayName();
    }

    public String getUrlName() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketLink that = (BitbucketLink)o;
        return Objects.equals(this.iconClassName, that.iconClassName) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.iconClassName, this.url);
    }

    public String toString() {
        return "BitbucketLink{iconClassName='" + this.iconClassName + "', url='" + this.url + "'}";
    }
}

