/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

public abstract class AbstractBitbucketTeam
implements BitbucketTeam {
    @JsonProperty(value="username")
    private String name;
    @JsonProperty(value="display_name")
    private String displayName;
    @JsonProperty(value="links")
    @JsonDeserialize(keyAs=String.class, contentUsing=BitbucketHref.Deserializer.class)
    private Map<String, List<BitbucketHref>> links;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    @JsonIgnore
    public Map<String, List<BitbucketHref>> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public void setLinks(Map<String, List<BitbucketHref>> links) {
        this.links = links;
    }

    @Override
    @JsonIgnore
    public String getLink(String name) {
        if (this.links == null) {
            return null;
        }
        List<BitbucketHref> hrefs = this.links.get(name);
        if (hrefs == null || hrefs.isEmpty()) {
            return null;
        }
        BitbucketHref href = hrefs.get(0);
        return href == null ? null : href.getHref();
    }
}

