/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.util.Secret;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

public class BitbucketClientCertificateAuthenticator
extends BitbucketAuthenticator {
    private final KeyStore keyStore;
    private final Secret password;
    private static final Logger LOGGER = Logger.getLogger(BitbucketClientCertificateAuthenticator.class.getName());

    public BitbucketClientCertificateAuthenticator(StandardCertificateCredentials credentials) {
        super((StandardCredentials)credentials);
        this.keyStore = credentials.getKeyStore();
        this.password = credentials.getPassword();
    }

    @Override
    public void configureBuilder(HttpClientBuilder builder) {
        try {
            builder.setSSLContext(this.buildSSLContext());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOGGER.log(Level.WARNING, "Failed to set up SSL context from provided client certificate: " + e.getMessage());
        }
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.loadKeyMaterial(this.keyStore, this.password.getPlainText().toCharArray());
        return contextBuilder.build();
    }
}

