/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketOAuth;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketOAuthService;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.Token;

public class BitbucketOAuthAuthenticator
extends BitbucketAuthenticator {
    private Token token;

    public BitbucketOAuthAuthenticator(StandardUsernamePasswordCredentials credentials) {
        super((StandardCredentials)credentials);
        OAuthConfig config = new OAuthConfig(credentials.getUsername(), credentials.getPassword().getPlainText());
        BitbucketOAuthService OAuthService2 = (BitbucketOAuthService)new BitbucketOAuth().createService(config);
        this.token = OAuthService2.getAccessToken(OAuthConstants.EMPTY_TOKEN, null);
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.addHeader("Authorization", "Bearer " + this.token.getToken());
    }

    @Override
    public BitbucketHref addAuthToken(BitbucketHref bitbucketHref) {
        String link = bitbucketHref.getHref();
        if (!link.startsWith("http")) {
            return bitbucketHref;
        }
        try {
            URI uri = new URI(link);
            String userInfo = "x-token-auth:{" + this.token.getToken() + "}";
            String newLink = new URI(uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
            return new BitbucketHref(bitbucketHref.getName(), newLink);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

