/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.util.Base64;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;

public class BitbucketOAuthService
extends OAuth20ServiceImpl {
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private DefaultApi20 api;
    private OAuthConfig config;

    public BitbucketOAuthService(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
        this.api = api;
        this.config = config;
    }

    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addHeader("Authorization", this.getHttpBasicAuthHeaderValue());
        request.addBodyParameter(GRANT_TYPE_KEY, GRANT_TYPE_CLIENT_CREDENTIALS);
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    public void signRequest(Token accessToken, OAuthRequest request) {
        request.addHeader("Authorization", this.getBearerAuthHeaderValue(accessToken));
    }

    private String getHttpBasicAuthHeaderValue() {
        String authStr = this.config.getApiKey() + ":" + this.config.getApiSecret();
        return "Basic " + Base64.encodeBytes((byte[])authStr.getBytes(StandardCharsets.UTF_8));
    }

    private String getBearerAuthHeaderValue(Token token) {
        return "Bearer " + token.getToken();
    }
}

