/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.ClassicDisplayURLProvider;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractBitbucketEndpoint
extends AbstractDescribableImpl<AbstractBitbucketEndpoint> {
    private final boolean manageHooks;
    @CheckForNull
    private final String credentialsId;
    private String bitbucketJenkinsRootUrl;

    AbstractBitbucketEndpoint(boolean manageHooks, @CheckForNull String credentialsId) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((String)credentialsId);
        this.credentialsId = manageHooks ? credentialsId : null;
    }

    @CheckForNull
    public abstract String getDisplayName();

    @NonNull
    public abstract String getServerUrl();

    @NonNull
    static String normalizeJenkinsRootUrl(String rootUrl) {
        return Util.ensureEndsWith((String)BitbucketEndpointConfiguration.normalizeServerUrl(rootUrl), (String)"/");
    }

    @CheckForNull
    public String getBitbucketJenkinsRootUrl() {
        return this.bitbucketJenkinsRootUrl;
    }

    @DataBoundSetter
    public void setBitbucketJenkinsRootUrl(String bitbucketJenkinsRootUrl) {
        if (this.manageHooks) {
            this.bitbucketJenkinsRootUrl = Util.fixEmptyAndTrim((String)bitbucketJenkinsRootUrl);
            if (this.bitbucketJenkinsRootUrl != null) {
                this.bitbucketJenkinsRootUrl = AbstractBitbucketEndpoint.normalizeJenkinsRootUrl(this.bitbucketJenkinsRootUrl);
            }
        } else {
            this.bitbucketJenkinsRootUrl = null;
        }
    }

    @NonNull
    public String getEndpointJenkinsRootUrl() {
        if (StringUtils.isBlank((String)this.bitbucketJenkinsRootUrl)) {
            return ClassicDisplayURLProvider.get().getRoot();
        }
        return this.bitbucketJenkinsRootUrl;
    }

    @NonNull
    public static String getEndpointJenkinsRootUrl(String serverUrl) {
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(serverUrl);
        if (endpoint != null) {
            return endpoint.getEndpointJenkinsRootUrl();
        }
        return ClassicDisplayURLProvider.get().getRoot();
    }

    @NonNull
    public abstract String getRepositoryUrl(@NonNull String var1, @NonNull String var2);

    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public StandardCredentials credentials() {
        return StringUtils.isBlank((String)this.credentialsId) ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getServerUrl()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentialsId), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(this.getServerUrl()))}));
    }

    @CheckForNull
    public BitbucketAuthenticator authenticator() {
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.getServerUrl()), (Credentials)this.credentials());
    }

    public AbstractBitbucketEndpointDescriptor getDescriptor() {
        return (AbstractBitbucketEndpointDescriptor)super.getDescriptor();
    }
}

