/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPushEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;

public class PushHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(PushHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
        BitbucketPushEvent push;
        if (payload != null && (push = instanceType == BitbucketType.SERVER ? BitbucketServerWebhookPayload.pushEventFromPayload(payload) : BitbucketCloudWebhookPayload.pushEventFromPayload(payload)) != null) {
            String owner = push.getRepository().getOwnerName();
            String repository = push.getRepository().getRepositoryName();
            if (push.getChanges().isEmpty()) {
                LOGGER.log(Level.INFO, "Received hook from Bitbucket. Processing push event on {0}/{1}", new Object[]{owner, repository});
                this.scmSourceReIndex(owner, repository);
            } else {
                SCMEvent.Type type = null;
                for (BitbucketPushEvent.Change change : push.getChanges()) {
                    if ((type == null || type == SCMEvent.Type.CREATED) && change.isCreated()) {
                        type = SCMEvent.Type.CREATED;
                        continue;
                    }
                    if ((type == null || type == SCMEvent.Type.REMOVED) && change.isClosed()) {
                        type = SCMEvent.Type.REMOVED;
                        continue;
                    }
                    type = SCMEvent.Type.UPDATED;
                }
                SCMHeadEvent.fireLater((SCMHeadEvent)new SCMHeadEvent<BitbucketPushEvent>(type, push, origin){

                    public boolean isMatch(@NonNull SCMNavigator navigator) {
                        if (!(navigator instanceof BitbucketSCMNavigator)) {
                            return false;
                        }
                        BitbucketSCMNavigator bbNav = (BitbucketSCMNavigator)navigator;
                        if (!this.isProjectKeyMatch(bbNav.getProjectKey())) {
                            return false;
                        }
                        if (!this.isServerUrlMatch(bbNav.getServerUrl())) {
                            return false;
                        }
                        return bbNav.getRepoOwner().equalsIgnoreCase(((BitbucketPushEvent)this.getPayload()).getRepository().getOwnerName());
                    }

                    private boolean isProjectKeyMatch(String projectKey) {
                        if (StringUtils.isBlank((String)projectKey)) {
                            return true;
                        }
                        if (((BitbucketPushEvent)this.getPayload()).getRepository().getProject() != null) {
                            return projectKey.equals(((BitbucketPushEvent)this.getPayload()).getRepository().getProject().getKey());
                        }
                        return true;
                    }

                    private boolean isServerUrlMatch(String serverUrl) {
                        if (serverUrl == null || "https://bitbucket.org".equals(serverUrl)) {
                            if (this.getPayload() instanceof BitbucketServerPushEvent) {
                                return false;
                            }
                        } else {
                            if (this.getPayload() instanceof BitbucketCloudPushEvent) {
                                return false;
                            }
                            Map<String, List<BitbucketHref>> links = ((BitbucketPushEvent)this.getPayload()).getRepository().getLinks();
                            if (links != null && links.containsKey("self")) {
                                boolean matches = false;
                                for (BitbucketHref link : links.get("self")) {
                                    try {
                                        URI navUri = new URI(serverUrl);
                                        URI evtUri = new URI(link.getHref());
                                        if (!navUri.getHost().equalsIgnoreCase(evtUri.getHost())) continue;
                                        matches = true;
                                        break;
                                    }
                                    catch (URISyntaxException uRISyntaxException) {
                                    }
                                }
                                return matches;
                            }
                        }
                        return true;
                    }

                    @NonNull
                    public String getSourceName() {
                        return ((BitbucketPushEvent)this.getPayload()).getRepository().getRepositoryName();
                    }

                    @NonNull
                    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
                        if (!(source instanceof BitbucketSCMSource)) {
                            return Collections.emptyMap();
                        }
                        BitbucketSCMSource src = (BitbucketSCMSource)source;
                        if (!this.isServerUrlMatch(src.getServerUrl())) {
                            return Collections.emptyMap();
                        }
                        if (!src.getRepoOwner().equalsIgnoreCase(((BitbucketPushEvent)this.getPayload()).getRepository().getOwnerName())) {
                            return Collections.emptyMap();
                        }
                        if (!src.getRepository().equalsIgnoreCase(((BitbucketPushEvent)this.getPayload()).getRepository().getRepositoryName())) {
                            return Collections.emptyMap();
                        }
                        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
                        for (BitbucketPushEvent.Change change : ((BitbucketPushEvent)this.getPayload()).getChanges()) {
                            if (change.isClosed()) {
                                result.put(new BranchSCMHead(change.getOld().getName()), null);
                                continue;
                            }
                            BitbucketPushEvent.Reference newChange = change.getNew();
                            BitbucketPushEvent.Target target = newChange.getTarget();
                            Object head = null;
                            String eventType = newChange.getType();
                            if ("tag".equals(eventType)) {
                                Date tagDate;
                                Date date = tagDate = newChange.getDate() != null ? newChange.getDate() : target.getDate();
                                if (tagDate == null) {
                                    tagDate = new Date();
                                }
                                head = new BitbucketTagSCMHead(newChange.getName(), tagDate.getTime());
                            } else {
                                head = new BranchSCMHead(newChange.getName());
                            }
                            result.put((SCMHead)head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, target.getHash()));
                        }
                        return result;
                    }

                    public boolean isMatch(@NonNull SCM scm) {
                        return false;
                    }
                }, (long)BitbucketSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }
}

