/*
 * The MIT License
 *
 * Copyright (c) 2016-2020, CloudBees Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server;

import hudson.model.ModelObject;

public enum BitbucketServerVersion implements ModelObject {
    VERSION_7("Bitbucket Data Center v8.x (and later)"),
    VERSION_6_5("Bitbucket Server v6.5 to v6.10 - EOL reached, any support DISMISSED"),
    VERSION_6("Bitbucket Server v6.0 to v6.4 - EOL reached, any support DISMISSED"),
    VERSION_5_10("Bitbucket Server v5.10 to v5.16 - EOL reached, any support DISMISSED"),
    VERSION_5("Bitbucket Server v5.9 (and earlier) - EOL reached, any support DISMISSED");

    private final String displayName;

    BitbucketServerVersion(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

}
