/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BranchWithHash;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.api.PullRequestBranchType;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.extension.FallbackToOtherRepositoryGitSCMExtension;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.SCMUtils;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Item;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.BitbucketServer;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang3.StringUtils;

public class BitbucketGitSCMBuilder
extends GitSCMBuilder<BitbucketGitSCMBuilder> {
    private static final Logger logger = Logger.getLogger(BitbucketGitSCMBuilder.class.getName());
    @NonNull
    private final BitbucketSCMSource scmSource;
    @NonNull
    private List<BitbucketHref> primaryCloneLinks = List.of();
    @NonNull
    private List<BitbucketHref> mirrorCloneLinks = List.of();
    @NonNull
    private BitbucketRepositoryProtocol protocol = BitbucketRepositoryProtocol.HTTP;

    public BitbucketGitSCMBuilder(@NonNull BitbucketSCMSource scmSource, @NonNull SCMHead head, @CheckForNull SCMRevision revision, @CheckForNull String credentialsId) {
        super(head, revision, scmSource.getServerUrl(), credentialsId);
        this.scmSource = scmSource;
        String serverURL = scmSource.getServerUrl();
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(new BitbucketServerEndpoint(null, serverURL, false, null, false, null));
        String repositoryURL = endpoint.getRepositoryUrl(scmSource.getRepoOwner(), scmSource.getRepository());
        if (BitbucketApiUtils.isCloud(endpoint.getServerURL())) {
            this.withBrowser((GitRepositoryBrowser)new BitbucketWeb(repositoryURL));
        } else {
            this.withBrowser((GitRepositoryBrowser)new BitbucketServer(repositoryURL));
        }
        this.withCredentials(credentialsId, null);
    }

    public BitbucketGitSCMBuilder withCloneLinks(@CheckForNull List<BitbucketHref> primaryCloneLinks, @CheckForNull List<BitbucketHref> mirrorCloneLinks) {
        if (primaryCloneLinks == null) {
            throw new IllegalArgumentException("Primary clone links shouldn't be null");
        }
        this.primaryCloneLinks = primaryCloneLinks;
        this.mirrorCloneLinks = Util.fixNull(mirrorCloneLinks);
        return this.withBitbucketRemote();
    }

    @NonNull
    public BitbucketSCMSource scmSource() {
        return this.scmSource;
    }

    @NonNull
    public BitbucketGitSCMBuilder withCredentials(String credentialsId, BitbucketRepositoryProtocol protocol) {
        if (StringUtils.isNotBlank((CharSequence)credentialsId)) {
            StandardCredentials credentials = BitbucketCredentials.lookupCredentials(this.scmSource.getServerUrl(), (Item)this.scmSource.getOwner(), credentialsId, StandardCredentials.class);
            if (protocol == null) {
                protocol = credentials instanceof SSHUserPrivateKey ? BitbucketRepositoryProtocol.SSH : BitbucketRepositoryProtocol.HTTP;
            }
        } else if (protocol == null) {
            protocol = BitbucketRepositoryProtocol.HTTP;
        }
        this.protocol = protocol;
        return (BitbucketGitSCMBuilder)this.withCredentials(credentialsId);
    }

    @NonNull
    public BitbucketGitSCMBuilder withBitbucketRemote() {
        SCMHead head = this.head();
        String headName = head.getName();
        if (head instanceof PullRequestSCMHead) {
            PullRequestSCMHead prHead = (PullRequestSCMHead)head;
            this.withPullRequestRemote(prHead, headName);
        } else if (head instanceof TagSCMHead) {
            this.withTagRemote(headName);
        } else {
            this.withBranchRemote(headName);
        }
        return this;
    }

    private void withPullRequestRemote(PullRequestSCMHead head, String headName) {
        String scmSourceRepoOwner = this.scmSource.getRepoOwner();
        String scmSourceRepository = this.scmSource.getRepository();
        String pullRequestRepoOwner = head.getRepoOwner();
        String pullRequestRepository = head.getRepository();
        boolean prFromTargetRepository = StringUtils.equalsIgnoreCase((CharSequence)pullRequestRepoOwner, (CharSequence)scmSourceRepoOwner) && pullRequestRepository.equalsIgnoreCase(scmSourceRepository);
        SCMRevision revision = this.revision();
        ChangeRequestCheckoutStrategy checkoutStrategy = head.getCheckoutStrategy();
        boolean cloneFromMirror = prFromTargetRepository && !this.mirrorCloneLinks.isEmpty() && revision instanceof PullRequestSCMRevision;
        String targetBranch = head.getTarget().getName();
        String branchName = head.getBranchName();
        boolean scmCloud = BitbucketApiUtils.isCloud(this.scmSource.getServerUrl());
        if (prFromTargetRepository) {
            if (head.getBranchType() == PullRequestBranchType.TAG) {
                this.withRefSpec("+refs/tags/" + branchName + ":refs/remotes/@{remote}/" + branchName);
            } else {
                this.withRefSpec("+refs/heads/" + branchName + ":refs/remotes/@{remote}/" + branchName);
            }
            if (cloneFromMirror) {
                PullRequestSCMRevision prRevision = (PullRequestSCMRevision)revision;
                String primaryRemoteName = this.remoteName().equals("primary") ? "primary-primary" : "primary";
                String cloneLink = this.getCloneLink(this.primaryCloneLinks);
                List<BranchWithHash> branchWithHashes = checkoutStrategy == ChangeRequestCheckoutStrategy.MERGE ? List.of(new BranchWithHash(branchName, SCMUtils.getHash(prRevision.getPull())), new BranchWithHash(targetBranch, SCMUtils.getHash((SCMRevision)prRevision))) : List.of(new BranchWithHash(branchName, SCMUtils.getHash(prRevision.getPull())));
                this.withExtension(new FallbackToOtherRepositoryGitSCMExtension(cloneLink, primaryRemoteName, branchWithHashes));
                this.withMirrorRemote();
            } else {
                this.withPrimaryRemote();
            }
        } else if (scmCloud) {
            this.withRefSpec("+refs/heads/" + branchName + ":refs/remotes/@{remote}/" + headName);
            String cloneLink = this.getCloudRepositoryUri(pullRequestRepoOwner, pullRequestRepository);
            this.withRemote(cloneLink);
        } else {
            String pullId = head.getId();
            this.withRefSpec("+refs/pull-requests/" + pullId + "/from:refs/remotes/@{remote}/" + headName);
            this.withPrimaryRemote();
        }
        if (head.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.MERGE) {
            String string;
            if (revision instanceof PullRequestSCMRevision) {
                PullRequestSCMRevision prRevision = (PullRequestSCMRevision)revision;
                string = SCMUtils.getHash((SCMRevision)prRevision);
            } else {
                string = null;
            }
            String hash = string;
            String refSpec = "+refs/heads/" + targetBranch + ":refs/remotes/@{remote}/" + targetBranch;
            if (!prFromTargetRepository && scmCloud) {
                String upstreamRemoteName = this.remoteName().equals("upstream") ? "upstream-upstream" : "upstream";
                this.withAdditionalRemote(upstreamRemoteName, this.getCloneLink(this.primaryCloneLinks), new String[]{refSpec});
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + upstreamRemoteName + "/" + targetBranch, hash));
            } else {
                this.withRefSpec(refSpec);
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + this.remoteName() + "/" + targetBranch, hash));
            }
        }
    }

    @NonNull
    private String getCloudRepositoryUri(@NonNull String owner, @NonNull String repository) {
        switch (this.protocol) {
            case HTTP: {
                return "https://bitbucket.org/" + owner + "/" + repository + ".git";
            }
            case SSH: {
                return "ssh://git@bitbucket.org/" + owner + "/" + repository + ".git";
            }
        }
        throw new IllegalArgumentException("Unsupported repository protocol: " + this.protocol);
    }

    private void withTagRemote(String headName) {
        this.withRefSpec("+refs/tags/" + headName + ":refs/tags/" + headName);
        if (this.mirrorCloneLinks.isEmpty()) {
            this.withPrimaryRemote();
        } else {
            this.withMirrorRemote();
        }
    }

    private void withBranchRemote(String headName) {
        this.withRefSpec("+refs/heads/" + headName + ":refs/remotes/@{remote}/" + headName);
        if (this.mirrorCloneLinks.isEmpty()) {
            this.withPrimaryRemote();
        } else {
            this.withMirrorRemote();
        }
    }

    private void withPrimaryRemote() {
        String cloneLink = this.getCloneLink(this.primaryCloneLinks);
        this.withRemote(cloneLink);
    }

    private void withMirrorRemote() {
        String cloneLink = this.getCloneLink(this.mirrorCloneLinks);
        this.withRemote(cloneLink);
    }

    private String getCloneLink(List<BitbucketHref> cloneLinks) {
        return cloneLinks.stream().filter(link -> this.protocol.matches(link.getName())).findAny().orElseThrow(() -> new IllegalStateException("Can't find clone link for protocol " + this.protocol + ". Did you disabled the protocol on Bitbucket Data Center configuration?")).getHref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        this.withBitbucketRemote();
        SCMHead head = this.head();
        SCMRevision rev = this.revision();
        try {
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                this.withHead(new SCMHead(prHead.getBranchName()));
                if (rev instanceof PullRequestSCMRevision) {
                    PullRequestSCMRevision prRev = (PullRequestSCMRevision)rev;
                    SCMRevision revision = this.resolvePullRequestRevision(prHead, prRev);
                    this.withRevision(revision);
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(head);
            this.withRevision(rev);
        }
    }

    @NonNull
    private SCMRevision resolvePullRequestRevision(PullRequestSCMHead prHead, PullRequestSCMRevision prRev) {
        SCMRevision revision = prRev.getPull();
        String hash = SCMUtils.getHash(revision);
        if (hash != null && StringUtils.length((CharSequence)hash) != 40) {
            try (BitbucketApi client = this.scmSource.buildBitbucketClient(prHead);){
                BitbucketCommit commit = client.resolveCommit(hash);
                if (commit != null) {
                    revision = new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)prHead, commit.getHash());
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can not retrieve commit for hash " + hash, e);
                throw new RuntimeException(e);
            }
        }
        return revision;
    }
}

