/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BitbucketEndpointDescriptor
extends Descriptor<BitbucketEndpoint> {
    @RequirePOST
    public ListBoxModel doFillCredentialsIdItems(@QueryParameter(fixEmpty=true) String credentialsId, @QueryParameter(value="serverUrl", fixEmpty=true) String serverURL) {
        Jenkins jenkins = BitbucketEndpointDescriptor.checkPermission();
        return BitbucketCredentials.fillCredentialsIdItems(serverURL, jenkins, StandardCredentials.class, credentialsId);
    }

    private static Jenkins checkPermission() {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.MANAGE);
        return jenkins;
    }

    @RequirePOST
    public ListBoxModel doFillHookSignatureCredentialsIdItems(@QueryParameter(fixEmpty=true) String hookSignatureCredentialsId, @QueryParameter(value="serverUrl", fixEmpty=true) String serverURL) {
        Jenkins jenkins = BitbucketEndpointDescriptor.checkPermission();
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeMatchingAs(ACL.SYSTEM2, (ItemGroup)jenkins, StringCredentials.class, URIRequirementBuilder.fromUri((String)serverURL).build(), CredentialsMatchers.always());
        if (hookSignatureCredentialsId != null) {
            result.includeCurrentValue(hookSignatureCredentialsId);
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public static FormValidation doCheckBitbucketJenkinsRootUrl(@QueryParameter String value) {
        BitbucketEndpointDescriptor.checkPermission();
        String url = Util.fixEmptyAndTrim((String)value);
        if (url == null) {
            return FormValidation.ok();
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
        }
        return FormValidation.ok();
    }
}

