/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.util.ListBoxModel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;

public final class BitbucketEndpointProvider {
    private BitbucketEndpointProvider() {
    }

    @NonNull
    public static List<BitbucketEndpoint> all() {
        return List.copyOf(BitbucketEndpointConfiguration.get().getEndpoints());
    }

    @NonNull
    public static ListBoxModel listEndpoints() {
        ListBoxModel result = new ListBoxModel();
        for (BitbucketEndpoint endpoint : BitbucketEndpointProvider.all()) {
            String serverUrl = endpoint.getServerURL();
            String displayName = endpoint.getDisplayName();
            result.add((String)(StringUtils.isBlank((CharSequence)displayName) ? serverUrl : displayName + " (" + serverUrl + ")"), serverUrl);
        }
        return result;
    }

    public static <T extends BitbucketEndpoint> Optional<T> lookupEndpoint(@CheckForNull String serverURL) {
        String normalizedServerURL = URLUtils.normalizeURL(serverURL);
        return BitbucketEndpointConfiguration.get().getEndpoints().stream().filter(endpoint -> Objects.equals(normalizedServerURL, endpoint.getServerURL())).map(endpoint -> endpoint).findFirst();
    }

    public static <T extends BitbucketEndpoint> Optional<T> lookupEndpoint(@CheckForNull String serverURL, @NonNull Class<T> clazz) {
        return BitbucketEndpointProvider.lookupEndpoint(serverURL).filter(clazz::isInstance).map(clazz::cast);
    }

    @NonNull
    public static <T extends BitbucketEndpoint> Collection<T> lookupEndpoint(@NonNull EndpointType type) {
        return BitbucketEndpointProvider.all().stream().filter(endpoint -> endpoint.getType() == type).map(endpoint -> endpoint).toList();
    }

    public static BitbucketEndpoint registerEndpoint(@NonNull String name, @NonNull String serverURL, @Nullable UnaryOperator<BitbucketEndpoint> endpointCustomiser) {
        BitbucketEndpoint endpoint = BitbucketApiUtils.isCloud(serverURL) ? new BitbucketCloudEndpoint() : new BitbucketServerEndpoint(name, serverURL, false, null, false, null);
        if (endpointCustomiser != null) {
            endpoint = (BitbucketEndpoint)endpointCustomiser.apply(endpoint);
        }
        BitbucketEndpointConfiguration.get().addEndpoint(endpoint);
        return endpoint;
    }

    public static boolean unregisterEndpoint(@NonNull String serverURL) {
        return BitbucketEndpointConfiguration.get().removeEndpoint(serverURL);
    }
}

