/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudAuthor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class BitbucketCloudCommit
implements BitbucketCommit {
    private String message;
    private String hash;
    private String author;
    private String committer;
    private Date committerDate;
    private List<String> parents;

    @JsonCreator
    public BitbucketCloudCommit(@JsonProperty(value="message") @Nullable String message, @JsonProperty(value="date") @Nullable String date, @JsonProperty(value="hash") @NonNull String hash, @JsonProperty(value="author") @Nullable BitbucketCloudAuthor author, @JsonProperty(value="committer") @Nullable BitbucketCloudAuthor committer, @JsonProperty(value="parents") @Nullable List<Parent> parents) {
        this.message = message;
        if (date != null) {
            this.committerDate = DateUtils.parseISODate(date);
        }
        this.hash = hash;
        if (author != null) {
            this.author = author.getRaw();
        }
        if (committer != null) {
            this.committer = committer.getRaw();
        }
        if (parents != null) {
            this.parents = parents.stream().map(Parent::getHash).toList();
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    @Deprecated(since="936.1.0", forRemoval=true)
    public String getDate() {
        return DateUtils.formatToISO(this.committerDate);
    }

    @Override
    @Deprecated(since="936.1.0", forRemoval=true)
    public long getDateMillis() {
        return this.committerDate != null ? this.committerDate.getTime() : 0L;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Date getAuthorDate() {
        return this.getCommitterDate();
    }

    @Override
    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    @Override
    public Date getCommitterDate() {
        return this.committerDate;
    }

    public void setCommitterDate(Date committerDate) {
        this.committerDate = committerDate;
    }

    @Override
    public Collection<String> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public static class Parent {
        private final String hash;

        @JsonCreator
        public Parent(@JsonProperty(value="hash") @NonNull String hash) {
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

