/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketEndpointConfiguration
extends GlobalConfiguration {
    private List<BitbucketEndpoint> endpoints = new CopyOnWriteArrayList<BitbucketEndpoint>();

    public BitbucketEndpointConfiguration() {
        this.load();
    }

    public static BitbucketEndpointConfiguration get() {
        return (BitbucketEndpointConfiguration)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(BitbucketEndpointConfiguration.class));
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String readResolveServerUrl(@CheckForNull String serverURL) {
        String normalizedURL = URLUtils.normalizeURL(serverURL);
        normalizedURL = (String)StringUtils.defaultIfBlank((CharSequence)normalizedURL, (CharSequence)"https://bitbucket.org");
        BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(null);
        if (endpoint == null && ACL.SYSTEM2.equals(Jenkins.getAuthentication2())) {
            endpoint = BitbucketApiUtils.isCloud(normalizedURL) ? new BitbucketCloudEndpoint() : new BitbucketServerEndpoint(normalizedURL);
            this.addEndpoint(endpoint);
        }
        return endpoint == null ? normalizedURL : endpoint.getServerURL();
    }

    public boolean isEndpointSelectable() {
        return this.getEndpoints().size() > 1;
    }

    @Deprecated
    public ListBoxModel getEndpointItems() {
        ListBoxModel result = new ListBoxModel();
        for (BitbucketEndpoint bitbucketEndpoint : this.getEndpoints()) {
            String serverUrl = bitbucketEndpoint.getServerURL();
            String displayName = bitbucketEndpoint.getDisplayName();
            result.add((String)(StringUtils.isBlank((CharSequence)displayName) ? serverUrl : displayName + " (" + serverUrl + ")"), serverUrl);
        }
        return result;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @NonNull
    public List<AbstractBitbucketEndpoint> getEndpoints() {
        List<BitbucketEndpoint> localEndpoints = this.endpoints;
        return CollectionUtils.isEmpty(localEndpoints) ? List.of(new BitbucketCloudEndpoint()) : Collections.unmodifiableList(localEndpoints);
    }

    public void setEndpoints(@CheckForNull List<? extends BitbucketEndpoint> endpoints) {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        ArrayList<BitbucketCloudEndpoint> eps = new ArrayList<BitbucketCloudEndpoint>(Util.fixNull(endpoints));
        HashSet<String> serverURLs = new HashSet<String>();
        ListIterator<BitbucketCloudEndpoint> iterator = eps.listIterator();
        while (iterator.hasNext()) {
            BitbucketEndpoint endpoint = (BitbucketEndpoint)iterator.next();
            String serverURL = endpoint.getServerURL();
            if (StringUtils.isBlank((CharSequence)serverURL) || serverURLs.contains(serverURL)) {
                iterator.remove();
                continue;
            }
            if (!(endpoint instanceof BitbucketCloudEndpoint) && BitbucketApiUtils.isCloud(serverURL)) {
                BitbucketCloudEndpoint cloudEndpoint = new BitbucketCloudEndpoint(false, 0, 0, endpoint.isManageHooks(), endpoint.getCredentialsId(), endpoint.isEnableHookSignature(), endpoint.getHookSignatureCredentialsId());
                cloudEndpoint.setBitbucketJenkinsRootUrl(endpoint.getEndpointJenkinsRootURL());
                iterator.set(cloudEndpoint);
            }
            serverURLs.add(serverURL);
        }
        if (eps.isEmpty()) {
            eps.add(new BitbucketCloudEndpoint());
        }
        this.endpoints = new CopyOnWriteArrayList<BitbucketEndpoint>(eps);
        this.save();
    }

    public boolean addEndpoint(@NonNull BitbucketEndpoint endpoint) {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        for (BitbucketEndpoint ep : this.endpoints) {
            if (!endpoint.isEquals(ep)) continue;
            return false;
        }
        this.endpoints.add(endpoint);
        return true;
    }

    public void updateEndpoint(@NonNull BitbucketEndpoint endpoint) {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        List<BitbucketEndpoint> newEndpoints = this.endpoints;
        boolean found = false;
        for (int i = 0; i < newEndpoints.size(); ++i) {
            BitbucketEndpoint ep = newEndpoints.get(i);
            if (!endpoint.isEquals(ep)) continue;
            newEndpoints.set(i, endpoint);
            found = true;
            break;
        }
        if (!found) {
            newEndpoints.add(endpoint);
        }
    }

    public boolean removeEndpoint(@NonNull BitbucketEndpoint endpoint) {
        return this.endpoints.removeIf(e -> e.isEquals(endpoint));
    }

    public boolean removeEndpoint(@CheckForNull String serverURL) {
        String fixedServerURL = URLUtils.normalizeURL(serverURL);
        return this.endpoints.removeIf(e -> Objects.equals(fixedServerURL, e.getServerURL()));
    }

    @NonNull
    public BitbucketEndpoint getDefaultEndpoint() {
        return this.getEndpoints().get(0);
    }

    @Deprecated(forRemoval=true)
    @CheckForNull
    public static String normalizeServerUrl(@CheckForNull String serverURL) {
        return URLUtils.normalizeURL(serverURL);
    }
}

