/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketSCMSourcePushHookReceiver
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSourcePushHookReceiver.class.getName());
    private static final String PATH = "bitbucket-scmsource-hook";
    public static final String FULL_PATH = "bitbucket-scmsource-hook/notify";

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/bitbucket-scmsource-hook/notify")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public String getUrlName() {
        return PATH;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpResponse doNotify(StaplerRequest2 req) throws IOException {
        String origin = SCMEvent.originOf((HttpServletRequest)req);
        String body = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String eventKey = req.getHeader("X-Event-Key");
        if (eventKey == null) {
            return HttpResponses.error((int)400, (String)"X-Event-Key HTTP header not found");
        }
        HookEventType type = HookEventType.fromString(eventKey);
        if (type == null) {
            LOGGER.info(() -> "Received unknown Bitbucket hook: " + eventKey + ". Skipping.");
            return HttpResponses.error((int)400, (String)("X-Event-Key HTTP header invalid: " + eventKey));
        }
        String bitbucketKey = req.getHeader("X-Bitbucket-Type");
        String serverURL = req.getParameter("server_url");
        BitbucketType instanceType = null;
        if (bitbucketKey != null) {
            instanceType = BitbucketType.fromString(bitbucketKey);
            LOGGER.log(Level.FINE, "X-Bitbucket-Type header found {0}.", (Object)instanceType);
        }
        if (serverURL != null) {
            if (instanceType == null) {
                LOGGER.log(Level.FINE, "server_url request parameter found. Bitbucket Native Server webhook incoming.");
                instanceType = BitbucketType.SERVER;
            } else {
                LOGGER.log(Level.FINE, "X-Bitbucket-Type header / server_url request parameter found. Bitbucket Plugin Server webhook incoming.");
            }
        } else {
            LOGGER.log(Level.FINE, "X-Bitbucket-Type header / server_url request parameter not found. Bitbucket Cloud webhook incoming.");
            instanceType = BitbucketType.CLOUD;
            serverURL = "https://bitbucket.org";
        }
        BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(null);
        if (endpoint != null) {
            if (endpoint.isEnableHookSignature()) {
                if (req.getHeader("X-Hub-Signature") == null) return HttpResponses.error((int)403, (String)"Payload has not be signed, configure the webHook secret in Bitbucket as documented at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
                HttpResponses.HttpResponseException error = this.checkSignature(req, body, endpoint);
                if (error != null) {
                    return error;
                }
            } else if (req.getHeader("X-Hub-Signature") == null) {
                LOGGER.log(Level.FINER, "Signature not configured for bitbucket endpoint {0}.", serverURL);
            }
        } else {
            LOGGER.log(Level.INFO, "No bitbucket endpoint found for {0} to verify the signature of incoming webhook.", serverURL);
        }
        HookProcessor hookProcessor = this.getHookProcessor(type);
        hookProcessor.process(type, body, instanceType, origin, serverURL);
        return HttpResponses.ok();
    }

    @Nullable
    private HttpResponses.HttpResponseException checkSignature(@NonNull StaplerRequest2 req, @NonNull String body, @NonNull BitbucketEndpoint endpoint) {
        block6: {
            LOGGER.log(Level.FINE, "Payload endpoint host {0}, request endpoint host {1}", new Object[]{endpoint, req.getRemoteAddr()});
            StringCredentials signatureCredentials = endpoint.hookSignatureCredentials();
            if (signatureCredentials != null) {
                String signatureHeader = req.getHeader("X-Hub-Signature");
                String bitbucketAlgorithm = StringUtils.trimToNull((String)StringUtils.substringBefore((String)signatureHeader, (String)"="));
                String bitbucketSignature = StringUtils.trimToNull((String)StringUtils.substringAfter((String)signatureHeader, (String)"="));
                HmacAlgorithms algorithm = this.getAlgorithm(bitbucketAlgorithm);
                if (algorithm == null) {
                    return HttpResponses.error((int)403, (String)("Signature " + bitbucketAlgorithm + " not supported"));
                }
                try {
                    String key = Secret.toString((Secret)signatureCredentials.getSecret());
                    HmacUtils util = new HmacUtils(algorithm, key.getBytes(StandardCharsets.UTF_8));
                    byte[] digest = util.hmac(body);
                    if (!MessageDigest.isEqual(Hex.decodeHex((String)bitbucketSignature), digest)) {
                        return HttpResponses.error((int)403, (String)"Signature verification failed");
                    }
                    break block6;
                }
                catch (IllegalArgumentException e) {
                    return HttpResponses.error((int)400, (String)("Signature method not supported: " + algorithm));
                }
                catch (DecoderException e) {
                    return HttpResponses.error((int)400, (String)("Hex signature can not be decoded: " + bitbucketSignature));
                }
            }
            String hookId = req.getHeader("X-Hook-UUID");
            String requestId = (String)ObjectUtils.firstNonNull((Object[])new String[]{req.getHeader("X-Request-UUID"), req.getHeader("X-Request-Id")});
            String hookSignatureCredentialsId = endpoint.getHookSignatureCredentialsId();
            LOGGER.log(Level.WARNING, "No credentials {0} found to verify the signature of incoming webhook {1} request {2}", new Object[]{hookSignatureCredentialsId, hookId, requestId});
            return HttpResponses.error((int)403, (String)("No credentials " + hookSignatureCredentialsId + " found in Jenkins to verify the signature"));
        }
        return null;
    }

    @CheckForNull
    private HmacAlgorithms getAlgorithm(String algorithm) {
        switch (StringUtils.lowerCase((String)algorithm)) {
            case "sha1": {
                return HmacAlgorithms.HMAC_SHA_1;
            }
            case "sha256": {
                return HmacAlgorithms.HMAC_SHA_256;
            }
            case "sha384": {
                return HmacAlgorithms.HMAC_SHA_384;
            }
            case "sha512": {
                return HmacAlgorithms.HMAC_SHA_512;
            }
        }
        return null;
    }

    HookProcessor getHookProcessor(HookEventType type) {
        return type.getProcessor();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

