/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.NativeServerPingHookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.NativeServerPullRequestHookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.NativeServerPushHookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.PullRequestHookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.PushHookProcessor;
import edu.umd.cs.findbugs.annotations.CheckForNull;

public enum HookEventType {
    PUSH("repo:push", PushHookProcessor.class),
    PULL_REQUEST_CREATED("pullrequest:created", PullRequestHookProcessor.class),
    PULL_REQUEST_UPDATED("pullrequest:updated", PullRequestHookProcessor.class),
    PULL_REQUEST_MERGED("pullrequest:fulfilled", PullRequestHookProcessor.class),
    PULL_REQUEST_DECLINED("pullrequest:rejected", PullRequestHookProcessor.class),
    PULL_REQUEST_APPROVED("pullrequest:approved", PullRequestHookProcessor.class),
    SERVER_REFS_CHANGED("repo:refs_changed", NativeServerPushHookProcessor.class),
    SERVER_MIRROR_REPO_SYNCHRONIZED("mirror:repo_synchronized", NativeServerPushHookProcessor.class),
    SERVER_PULL_REQUEST_OPENED("pr:opened", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_MERGED("pr:merged", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_DECLINED("pr:declined", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_DELETED("pr:deleted", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_APPROVED("pr:reviewer:approved", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_MODIFIED("pr:modified", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_REVIEWER_UPDATED("pr:reviewer:updated", NativeServerPullRequestHookProcessor.class),
    SERVER_PULL_REQUEST_FROM_REF_UPDATED("pr:from_ref_updated", NativeServerPullRequestHookProcessor.class),
    SERVER_PING("diagnostics:ping", NativeServerPingHookProcessor.class);

    private final String key;
    private final Class<?> clazz;

    private <P extends HookProcessor> HookEventType(String key, Class<P> clazz) {
        this.key = key;
        this.clazz = clazz;
    }

    @CheckForNull
    public static HookEventType fromString(String key) {
        for (HookEventType value : HookEventType.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        return null;
    }

    public HookProcessor getProcessor() {
        try {
            return (HookProcessor)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)("Can not instantiate hook payload processor: " + e.getMessage()));
        }
    }

    public String getKey() {
        return this.key;
    }
}

