/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.util.SystemProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

public abstract class HookProcessor {
    protected static final String SCAN_ON_EMPTY_CHANGES_PROPERTY_NAME = "bitbucket.hooks.processor.scanOnEmptyChanges";
    protected static final boolean SCAN_ON_EMPTY_CHANGES = SystemProperties.getBoolean((String)"bitbucket.hooks.processor.scanOnEmptyChanges", (boolean)true);
    private static final Logger LOGGER = Logger.getLogger(HookProcessor.class.getName());

    public abstract void process(HookEventType var1, String var2, BitbucketType var3, String var4);

    public void process(HookEventType type, String payload, BitbucketType instanceType, String origin, String serverURL) {
        this.process(type, payload, instanceType, origin);
    }

    protected void scmSourceReIndex(String owner, String repository, String mirrorId) {
        try (ACLContext context = ACL.as2((Authentication)ACL.SYSTEM2);){
            boolean reindexed = false;
            for (SCMSourceOwner scmOwner : SCMSourceOwners.all()) {
                List sources = scmOwner.getSCMSources();
                for (SCMSource source : sources) {
                    BitbucketSCMSource scmSource;
                    if (!(source instanceof BitbucketSCMSource) || !StringUtils.equalsIgnoreCase((CharSequence)(scmSource = (BitbucketSCMSource)source).getRepoOwner(), (CharSequence)owner) || !scmSource.getRepository().equals(repository) || mirrorId != null && !StringUtils.equalsIgnoreCase((CharSequence)mirrorId, (CharSequence)scmSource.getMirrorId())) continue;
                    LOGGER.log(Level.INFO, "Multibranch project found, reindexing " + scmOwner.getName());
                    scmOwner.onSCMSourceUpdated(source);
                    reindexed = true;
                }
            }
            if (!reindexed) {
                LOGGER.log(Level.INFO, "No multibranch project matching for reindex on {0}/{1}", new Object[]{owner, repository});
            }
        }
    }

    protected void notifyEvent(SCMHeadEvent<?> event, int delaySeconds) {
        if (delaySeconds == 0) {
            SCMHeadEvent.fireNow(event);
        } else {
            SCMHeadEvent.fireLater(event, (long)(delaySeconds > 0 ? (long)delaySeconds : (long)BitbucketSCMSource.getEventDelaySeconds()), (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

