/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.ServerPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerChange;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerMirrorRepoSynchronizedEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerRefsChangedEvent;
import com.google.common.collect.HashMultimap;
import hudson.RestrictedSince;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class NativeServerPushHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(NativeServerPushHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
    }

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin, String serverUrl) {
        String mirrorId;
        BitbucketServerCommit refCommit;
        List<NativeServerChange> changes;
        BitbucketServerRepository repository;
        block15: {
            if (payload == null) {
                return;
            }
            try {
                Object event;
                if (hookEvent == HookEventType.SERVER_REFS_CHANGED) {
                    event = JsonParser.toJava(payload, NativeServerRefsChangedEvent.class);
                    repository = ((NativeServerRefsChangedEvent)event).getRepository();
                    changes = ((NativeServerRefsChangedEvent)event).getChanges();
                    refCommit = ((NativeServerRefsChangedEvent)event).getToCommit();
                    mirrorId = null;
                    break block15;
                }
                if (hookEvent == HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED) {
                    event = JsonParser.toJava(payload, NativeServerMirrorRepoSynchronizedEvent.class);
                    repository = ((NativeServerMirrorRepoSynchronizedEvent)event).getRepository();
                    changes = ((NativeServerMirrorRepoSynchronizedEvent)event).getChanges();
                    refCommit = null;
                    mirrorId = ((NativeServerMirrorRepoSynchronizedEvent)event).getMirrorServer().getId();
                    if (((NativeServerMirrorRepoSynchronizedEvent)event).getRefLimitExceeded()) {
                        String owner = repository.getOwnerName();
                        String repositoryName = repository.getRepositoryName();
                        LOGGER.log(Level.INFO, "Received mirror synchronized event with refLimitExceeded from Bitbucket. Processing with indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repositoryName, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                        this.scmSourceReIndex(owner, repositoryName, mirrorId);
                        return;
                    }
                    break block15;
                }
                throw new UnsupportedOperationException("Hook event of type " + hookEvent + " is not supported.\nPlease fill an issue at https://issues.jenkins.io to the bitbucket-branch-source-plugin component.");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
                return;
            }
        }
        if (changes.isEmpty()) {
            String owner = repository.getOwnerName();
            String repositoryName = repository.getRepositoryName();
            if (SCAN_ON_EMPTY_CHANGES) {
                LOGGER.log(Level.INFO, "Received push hook with empty changes from Bitbucket. Processing indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repositoryName, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                this.scmSourceReIndex(owner, repositoryName, mirrorId);
            } else {
                LOGGER.log(Level.INFO, "Received push hook with empty changes from Bitbucket for {0}/{1}. Skipping.", new Object[]{owner, repositoryName});
            }
        } else {
            HashMultimap events = HashMultimap.create();
            for (NativeServerChange change : changes) {
                String type = change.getType();
                if ("UPDATE".equals(type)) {
                    events.put((Object)SCMEvent.Type.UPDATED, (Object)change);
                    continue;
                }
                if ("DELETE".equals(type)) {
                    events.put((Object)SCMEvent.Type.REMOVED, (Object)change);
                    continue;
                }
                if ("ADD".equals(type)) {
                    events.put((Object)SCMEvent.Type.CREATED, (Object)change);
                    continue;
                }
                LOGGER.log(Level.INFO, "Unknown change event type of {0} received from Bitbucket Server", type);
            }
            for (SCMEvent.Type type : events.keySet()) {
                ServerPushEvent headEvent = new ServerPushEvent(serverUrl, type, events.get((Object)type), origin, repository, refCommit, mirrorId);
                this.notifyEvent(headEvent, BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }
}

