/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class JsonParser {
    public static final ObjectMapper mapper = JsonParser.createObjectMapper();

    public static <T> T toJava(String data, Class<T> type) throws IOException {
        return JsonParser.toJava(new StringReader(data), type);
    }

    public static <T> T toJava(InputStream data, Class<T> type) throws IOException {
        return JsonParser.toJava(new InputStreamReader(data, StandardCharsets.UTF_8), type);
    }

    public static <T> T toJava(Reader data, Class<T> type) throws IOException {
        return (T)mapper.readValue(data, type);
    }

    public static <T> T toJava(String data, TypeReference<T> type) throws IOException {
        return (T)mapper.readValue(data, type);
    }

    public static String toJson(Object value) throws IOException {
        return mapper.writeValueAsString(value);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat((DateFormat)new StdDateFormat());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

