/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.FolderProperty;
import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.TransientFolderActionFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.ListView;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.security.AccessControlled;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.views.ListViewColumn;
import hudson.views.ViewJobFilter;
import io.jenkins.servlet.ServletExceptionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import jenkins.security.stapler.StaplerNotDispatchable;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class Folder
extends AbstractFolder<TopLevelItem>
implements DirectlyModifiableTopLevelItemGroup {
    public static final AlternativeUiTextProvider.Message<Folder> NEW_PRONOUN = new AlternativeUiTextProvider.Message();
    @Deprecated
    private transient DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    @Deprecated
    private transient DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> filters;
    private transient ItemGroupMixIn mixin;
    @Deprecated
    protected volatile transient List<Action> transientActions = new Vector<Action>();
    private static final Logger LOGGER = Logger.getLogger(Folder.class.getName());

    public Folder(ItemGroup parent, String name) {
        super(parent, name);
        this.init();
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.updateTransientActions();
    }

    @Override
    protected final void init() {
        super.init();
        this.mixin = new MixInImpl(this);
    }

    @Override
    protected void initViews(List<View> views) throws IOException {
        if (this.columns != null || this.filters != null) {
            if (this.columns == null) {
                this.columns = new DescribableList((Saveable)this, (Collection)ListViewColumn.createDefaultInitialColumnList());
            }
            if (this.filters == null) {
                this.filters = new DescribableList((Saveable)this);
            }
            ListView lv = new ListView("All", (ViewGroup)this);
            views.add((View)lv);
            lv.getColumns().replaceBy((Collection)this.columns.toList());
            lv.getJobFilters().replaceBy((Collection)this.filters.toList());
            lv.setIncludeRegex(".*");
            lv.save();
        } else {
            super.initViews(views);
        }
    }

    public void onCreatedFromScratch() {
        this.updateTransientActions();
    }

    @Deprecated
    protected void updateTransientActions() {
        this.transientActions = this.createTransientActions();
    }

    @Deprecated
    protected List<Action> createTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (TransientFolderActionFactory tpaf : TransientFolderActionFactory.all()) {
            ta.addAll(Util.fixNull(tpaf.createFor(this)));
        }
        for (FolderProperty p : this.getProperties().getAll(FolderProperty.class)) {
            ta.addAll(Util.fixNull(p.getFolderActions()));
        }
        return ta;
    }

    public String getNewPronoun() {
        return AlternativeUiTextProvider.get(NEW_PRONOUN, (Object)((Object)this), (String)Messages.Folder_DefaultPronoun());
    }

    @Deprecated
    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return new DescribableList((Saveable)this, (Collection)ListViewColumn.createDefaultInitialColumnList());
    }

    @Deprecated
    public void addProperty(FolderProperty<?> p) throws IOException {
        this.addProperty((AbstractFolderProperty)p);
    }

    public void onCopiedFrom(Item _src) {
        Folder src = (Folder)_src;
        for (TopLevelItem item : src.getItems()) {
            try {
                this.copy(item, item.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to copy " + src + " into " + this, e);
            }
        }
    }

    @POST
    public TopLevelItem doCreateItem(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (Util.isOverridden(Folder.class, ((Object)((Object)this)).getClass(), (String)"doCreateItem", (Class[])new Class[]{StaplerRequest.class, StaplerResponse.class})) {
            try {
                return this.doCreateItem(req != null ? StaplerRequest.fromStaplerRequest2((StaplerRequest2)req) : null, rsp != null ? StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp) : null);
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        }
        return this.doCreateItemImpl(req, rsp);
    }

    @Deprecated
    @StaplerNotDispatchable
    public TopLevelItem doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            return this.doCreateItemImpl(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, rsp != null ? StaplerResponse.toStaplerResponse2((StaplerResponse)rsp) : null);
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private TopLevelItem doCreateItemImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        TopLevelItem nue = this.mixin.createTopLevelItem(req, rsp);
        if (!this.isAllowedChild(nue)) {
            try {
                nue.delete();
            }
            catch (InterruptedException x) {
                throw new IOException(x.toString(), x);
            }
            throw new IOException("forbidden child type");
        }
        return nue;
    }

    public <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        if (!this.isAllowedChild(src)) {
            throw new IOException("forbidden child type");
        }
        return (T)this.mixin.copy(src, name);
    }

    public TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        TopLevelItem nue = this.mixin.createProjectFromXML(name, xml);
        if (!this.isAllowedChild(nue)) {
            try {
                nue.delete();
            }
            catch (InterruptedException x) {
                throw new IOException(x.toString(), x);
            }
            throw new IOException("forbidden child type");
        }
        return nue;
    }

    public <T extends TopLevelItem> T createProject(@NonNull Class<T> type, @NonNull String name) throws IOException {
        return (T)((TopLevelItem)type.cast(this.createProject((TopLevelItemDescriptor)Jenkins.get().getDescriptorOrDie(type), name)));
    }

    public TopLevelItem createProject(@NonNull TopLevelItemDescriptor type, @NonNull String name) throws IOException {
        return this.createProject(type, name, true);
    }

    public TopLevelItem createProject(@NonNull TopLevelItemDescriptor type, @NonNull String name, boolean notify) throws IOException {
        if (!this.isAllowedChildDescriptor(type)) {
            throw new IOException("forbidden child type");
        }
        return this.mixin.createProject(type, name, notify);
    }

    @Override
    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        if (Util.isOverridden(Folder.class, ((Object)((Object)this)).getClass(), (String)"submit", (Class[])new Class[]{StaplerRequest.class, StaplerResponse.class})) {
            try {
                this.submit(req != null ? StaplerRequest.fromStaplerRequest2((StaplerRequest2)req) : null, rsp != null ? StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp) : null);
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.submitImpl(req, rsp);
        }
    }

    @Override
    @Deprecated
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        try {
            this.submitImpl(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, rsp != null ? StaplerResponse.toStaplerResponse2((StaplerResponse)rsp) : null);
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void submitImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        this.updateTransientActions();
    }

    public List<TopLevelItemDescriptor> getItemDescriptors() {
        ArrayList<TopLevelItemDescriptor> r = new ArrayList<TopLevelItemDescriptor>();
        for (TopLevelItemDescriptor tid : Items.all()) {
            if (!this.isAllowedChildDescriptor(tid)) continue;
            r.add(tid);
        }
        return r;
    }

    public boolean isAllowedChildDescriptor(TopLevelItemDescriptor tid) {
        for (FolderProperty p : this.getProperties().getAll(FolderProperty.class)) {
            if (p.allowsParentToCreate(tid)) continue;
            return false;
        }
        if (!this.getACL().hasCreatePermission2(Jenkins.getAuthentication2(), (ItemGroup)this, tid)) {
            return false;
        }
        return tid.isApplicableIn((ItemGroup)this);
    }

    public boolean isAllowedChild(TopLevelItem tid) {
        for (FolderProperty p : this.getProperties().getAll(FolderProperty.class)) {
            if (p.allowsParentToHave(tid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean canAdd(TopLevelItem item) {
        return this.isAllowedChild(item);
    }

    public <I extends TopLevelItem> I add(I item, String name) throws IOException, IllegalArgumentException {
        if (!this.canAdd(item)) {
            throw new IllegalArgumentException();
        }
        this.addLoadedChild(item, name);
        return item;
    }

    public void remove(TopLevelItem item) throws IOException, IllegalArgumentException {
        this.items.remove(item.getName());
    }

    private class MixInImpl
    extends ItemGroupMixIn {
        private MixInImpl(Folder parent) {
            super((ItemGroup)parent, (AccessControlled)parent);
        }

        protected void add(TopLevelItem item) {
            Folder.this.itemsPut(item.getName(), item);
        }

        protected File getRootDirFor(String name) {
            return Folder.this.getRootDirFor(name);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderDescriptor {
        public String getDescription() {
            return Messages.Folder_Description();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new Folder(parent, name);
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-folder icon-sm", "plugin/cloudbees-folder/images/svgs/folder.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-folder icon-md", "plugin/cloudbees-folder/images/svgs/folder.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-folder icon-lg", "plugin/cloudbees-folder/images/svgs/folder.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-folder icon-xlg", "plugin/cloudbees-folder/images/svgs/folder.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-disabled icon-sm", "plugin/cloudbees-folder/images/svgs/folder-disabled.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-disabled icon-md", "plugin/cloudbees-folder/images/svgs/folder-disabled.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-disabled icon-lg", "plugin/cloudbees-folder/images/svgs/folder-disabled.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-disabled icon-xlg", "plugin/cloudbees-folder/images/svgs/folder-disabled.svg", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-store icon-sm", "plugin/cloudbees-folder/images/svgs/folder-store.svg", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-store icon-md", "plugin/cloudbees-folder/images/svgs/folder-store.svg", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-store icon-lg", "plugin/cloudbees-folder/images/svgs/folder-store.svg", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-folder-store icon-xlg", "plugin/cloudbees-folder/images/svgs/folder-store.svg", "width: 48px; height: 48px;"));
        }
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    @Extension
    public static class DeprecatedTransientActions
    extends TransientActionFactory<Folder> {
        public Class<Folder> type() {
            return Folder.class;
        }

        public Collection<? extends Action> createFor(Folder target) {
            return target.transientActions;
        }
    }
}

