/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.custom;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.custom.AbstractCustomProvider;
import org.jenkinsci.plugins.configfiles.custom.security.CustomizedCredentialMapping;
import org.jenkinsci.plugins.configfiles.custom.security.HasCustomizedCredentialMappings;
import org.kohsuke.stapler.DataBoundConstructor;

public class CustomConfig
extends Config
implements HasCustomizedCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<CustomizedCredentialMapping> customizedCredentialMappings;

    public CustomConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
        this.customizedCredentialMappings = new ArrayList<CustomizedCredentialMapping>();
    }

    @DataBoundConstructor
    public CustomConfig(String id, String name, String comment, String content, List<CustomizedCredentialMapping> customizedCredentialMappings) {
        super(id, name, comment, content, CustomConfigProvider.class.getName());
        this.customizedCredentialMappings = customizedCredentialMappings == null ? new ArrayList() : customizedCredentialMappings;
    }

    public CustomConfig(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, content, providerId);
        this.customizedCredentialMappings = new ArrayList<CustomizedCredentialMapping>();
    }

    @Override
    public List<CustomizedCredentialMapping> getCustomizedCredentialMappings() {
        return this.customizedCredentialMappings == null ? new ArrayList() : this.customizedCredentialMappings;
    }

    @Extension(ordinal=50.0)
    public static class CustomConfigProvider
    extends AbstractCustomProvider {
        protected transient String ID_PREFIX;

        public CustomConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.SHELL;
        }

        public String getDisplayName() {
            return Messages.custom_provider_name();
        }

        @Override
        @NonNull
        public CustomConfig newConfig(@NonNull String id) {
            return new CustomConfig(id, Messages.CustomConfig_SettingsName(), Messages.CustomConfig_SettingsComment(), "", this.getProviderId());
        }

        @Override
        protected String getXmlFileName() {
            return "custom-config-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.custom.CustomConfigProvider", CustomConfigProvider.class);
        }
    }
}

