/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ServerCredentialMapping
extends AbstractDescribableImpl<ServerCredentialMapping>
implements Serializable {
    private final String serverId;
    private final String credentialsId;
    private static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ServerCredentialMapping(String serverId, String credentialsId) {
        this.serverId = serverId;
        this.credentialsId = credentialsId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public Descriptor<ServerCredentialMapping> getDescriptor() {
        return DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ServerCredentialMapping> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @AncestorInPath Item projectOrFolder, @QueryParameter String serverId) {
            Jenkins contextToCheck;
            List<Permission> permsToCheck = projectOrFolder == null ? Arrays.asList(Jenkins.MANAGE) : Arrays.asList(Item.EXTENDED_READ, CredentialsProvider.USE_ITEM);
            Object object = contextToCheck = projectOrFolder == null ? Jenkins.get() : projectOrFolder;
            if (permsToCheck.stream().anyMatch(arg_0 -> DescriptorImpl.lambda$doFillCredentialsIdItems$0((AccessControlled)contextToCheck, arg_0))) {
                return new StandardUsernameListBoxModel().includeCurrentValue(serverId);
            }
            List<Object> domainRequirements = Collections.emptyList();
            if (serverId != null && !serverId.isBlank()) {
                domainRequirements = Collections.singletonList(new MavenServerIdRequirement(serverId));
            }
            return serverId != null ? new StandardUsernameListBoxModel().includeAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication2() : ACL.SYSTEM2, context, StandardUsernameCredentials.class, domainRequirements).includeCurrentValue(serverId) : new StandardUsernameListBoxModel().includeAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication2() : ACL.SYSTEM2, context, StandardUsernameCredentials.class, domainRequirements);
        }

        public String getDisplayName() {
            return "";
        }

        private static /* synthetic */ boolean lambda$doFillCredentialsIdItems$0(AccessControlled contextToCheck, Permission per) {
            return !contextToCheck.hasPermission(per);
        }
    }
}

