/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;

public abstract class MultiBinding<C extends StandardCredentials>
extends AbstractDescribableImpl<MultiBinding<C>>
implements ExtensionPoint {
    private final String credentialsId;

    protected MultiBinding(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    protected abstract Class<C> type();

    public final String getCredentialsId() {
        return this.credentialsId;
    }

    public abstract MultiEnvironment bind(@Nonnull Run<?, ?> var1, @Nullable FilePath var2, @Nullable Launcher var3, @Nonnull TaskListener var4) throws IOException, InterruptedException;

    public Set<String> variables() {
        return Collections.emptySet();
    }

    public Set<String> variables(@Nonnull Run<?, ?> build) throws CredentialNotFoundException {
        if (Util.isOverridden(MultiBinding.class, ((Object)((Object)this)).getClass(), (String)"variables", (Class[])new Class[0])) {
            return this.variables();
        }
        throw new AbstractMethodError("Implement variables");
    }

    @Nonnull
    protected final C getCredentials(@Nonnull Run<?, ?> build) throws CredentialNotFoundException {
        IdCredentials cred = CredentialsProvider.findCredentialById((String)this.credentialsId, IdCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
        if (cred == null) {
            throw new CredentialNotFoundException("Could not find credentials entry with ID '" + this.credentialsId + "'");
        }
        if (this.type().isInstance(cred)) {
            CredentialsProvider.track(build, (Credentials)cred);
            return (C)((StandardCredentials)this.type().cast(cred));
        }
        Descriptor expected = Jenkins.getActiveInstance().getDescriptor(this.type());
        throw new CredentialNotFoundException("Credentials '" + this.credentialsId + "' is of type '" + cred.getDescriptor().getDisplayName() + "' where '" + (expected != null ? expected.getDisplayName() : this.type().getName()) + "' was expected");
    }

    public BindingDescriptor<C> getDescriptor() {
        return (BindingDescriptor)super.getDescriptor();
    }

    protected static final class NullUnbinder
    implements Unbinder {
        private static final long serialVersionUID = 1L;

        protected NullUnbinder() {
        }

        @Override
        public void unbind(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        }
    }

    public static interface Unbinder
    extends Serializable {
        public void unbind(@Nonnull Run<?, ?> var1, @Nullable FilePath var2, @Nullable Launcher var3, @Nonnull TaskListener var4) throws IOException, InterruptedException;
    }

    public static final class MultiEnvironment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Deprecated
        private transient Map<String, String> values = null;
        private Map<String, String> secretValues;
        private Map<String, String> publicValues;
        private final Unbinder unbinder;

        public MultiEnvironment(Map<String, String> secretValues) {
            this(secretValues, Collections.emptyMap());
        }

        public MultiEnvironment(Map<String, String> secretValues, Map<String, String> publicValues) {
            this(secretValues, publicValues, new NullUnbinder());
        }

        public MultiEnvironment(Map<String, String> secretValues, Unbinder unbinder) {
            this(secretValues, Collections.emptyMap(), unbinder);
        }

        public MultiEnvironment(Map<String, String> secretValues, Map<String, String> publicValues, Unbinder unbinder) {
            this.secretValues = new LinkedHashMap<String, String>(secretValues);
            this.publicValues = new LinkedHashMap<String, String>(publicValues);
            if (!CollectionUtils.intersection(secretValues.keySet(), publicValues.keySet()).isEmpty()) {
                throw new IllegalArgumentException("Cannot use the same key in both secretValues and publicValues");
            }
            this.unbinder = unbinder;
        }

        private Object readResolve() {
            if (this.values != null) {
                this.secretValues = this.values;
                this.publicValues = Collections.emptyMap();
                this.values = null;
            }
            return this;
        }

        @Deprecated
        public Map<String, String> getValues() {
            return Collections.unmodifiableMap(this.secretValues);
        }

        public Map<String, String> getSecretValues() {
            return Collections.unmodifiableMap(this.secretValues);
        }

        public Map<String, String> getPublicValues() {
            return Collections.unmodifiableMap(this.publicValues);
        }

        public Unbinder getUnbinder() {
            return this.unbinder;
        }
    }
}

