/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.security.Permission;
import hudson.util.FormApply;
import hudson.util.HttpResponses;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class CredentialsSelectHelper
extends Descriptor<CredentialsSelectHelper>
implements Describable<CredentialsSelectHelper> {
    public static final Permission CREATE = CredentialsProvider.CREATE;

    public CredentialsSelectHelper() {
        super(CredentialsSelectHelper.class);
    }

    public CredentialsSelectHelper getDescriptor() {
        return this;
    }

    public DescriptorExtensionList<Credentials, Descriptor<Credentials>> getCredentialsDescriptors() {
        return Jenkins.getInstance().getDescriptorList(Credentials.class);
    }

    public CredentialsStoreAction.DomainWrapper getWrapper() {
        return new CredentialsStoreAction(){

            @NonNull
            public CredentialsStore getStore() {
                return CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
            }
        }.getDomain("_");
    }

    public String getDisplayName() {
        return Messages.CredentialsSelectHelper_DisplayName();
    }

    @RequirePOST
    public void doAddCredentials(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        CredentialsStoreAction.DomainWrapper wrapper = this.getWrapper();
        if (!wrapper.getStore().isDomainsModifiable()) {
            HttpResponses.status((int)400).generateResponse(req, rsp, null);
            FormApply.applyResponse((String)"window.alert('Domain is read-only')").generateResponse(req, rsp, null);
        }
        wrapper.getStore().checkPermission(CredentialsStoreAction.CREATE);
        JSONObject data = req.getSubmittedForm();
        Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data.getJSONObject("credentials"));
        wrapper.getStore().addCredentials(wrapper.getDomain(), credentials);
        FormApply.applyResponse((String)"window.credentials.refreshAll();").generateResponse(req, rsp, null);
    }
}

