/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessDeniedException3;
import hudson.security.Permission;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@Extension
public class UserCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(UserCredentialsProperty.class.getName());
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.USER);
    @GuardedBy(value="self")
    private static final WeakHashMap<User, UserCredentialsProperty> emptyProperties = new WeakHashMap();

    @Override
    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof User) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @Override
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        if (object instanceof User) {
            return new StoreImpl((User)object);
        }
        return null;
    }

    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        UserCredentialsProperty property;
        User user;
        if (authentication == null) {
            authentication = ACL.SYSTEM2;
        }
        if (!ACL.SYSTEM2.equals(authentication) && (user = User.get2((Authentication)authentication)) != null && (property = (UserCredentialsProperty)user.getProperty(UserCredentialsProperty.class)) != null) {
            boolean needImpersonation = !user.equals(User.current());
            Supplier<List> credentials = () -> DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, CredentialsMatchers.always());
            if (needImpersonation) {
                try (ACLContext ac = ACL.as((User)user);){
                    List list = credentials.get();
                    return list;
                }
            }
            return credentials.get();
        }
        return Collections.emptyList();
    }

    @Override
    public String getIconClassName() {
        return "symbol-person";
    }

    public static class StoreImpl
    extends CredentialsStore {
        private final User user;
        private final UserFacingAction storeAction;
        private transient UserCredentialsProperty property;

        private StoreImpl(User user) {
            this.user = user;
            this.storeAction = new UserFacingAction(this);
        }

        @Override
        @Nullable
        public CredentialsStoreAction getStoreAction() {
            return this.storeAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UserCredentialsProperty getInstance() {
            if (this.property == null) {
                UserCredentialsProperty property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                if (property == null) {
                    WeakHashMap<User, UserCredentialsProperty> weakHashMap = emptyProperties;
                    synchronized (weakHashMap) {
                        property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                        if (property == null && (property = emptyProperties.get(this.user)) == null) {
                            property = new UserCredentialsProperty(new DomainCredentials[0]);
                            property._setUser(this.user);
                            emptyProperties.put(this.user, property);
                        }
                    }
                }
                this.property = property;
            }
            return this.property;
        }

        @Override
        @NonNull
        public ModelObject getContext() {
            return this.user;
        }

        @Override
        public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
            return this.getACL().hasPermission2(a, permission);
        }

        @Override
        @NonNull
        public ACL getACL() {
            return new ACL(){

                public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                    return user.equals(User.getById((String)a.getName(), (boolean)true)) && user.getACL().hasPermission2(a, permission);
                }
            };
        }

        @Override
        @Exported
        @NonNull
        public List<Domain> getDomains() {
            return Collections.unmodifiableList(new ArrayList<Domain>(this.getInstance().getDomainCredentialsMap().keySet()));
        }

        @Override
        @Exported
        @NonNull
        public List<Credentials> getCredentials(@NonNull Domain domain) {
            return this.getInstance().getCredentials(domain);
        }

        @Override
        public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            return this.getInstance().addDomain(domain, credentials);
        }

        @Override
        public boolean removeDomain(@NonNull Domain domain) throws IOException {
            return this.getInstance().removeDomain(domain);
        }

        @Override
        public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            return this.getInstance().updateDomain(current, replacement);
        }

        @Override
        public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return this.getInstance().addCredentials(domain, credentials);
        }

        @Override
        public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return this.getInstance().removeCredentials(domain, credentials);
        }

        @Override
        public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            return this.getInstance().updateCredentials(domain, current, replacement);
        }

        @Override
        public String getRelativeLinkToContext() {
            StaplerRequest2 request = Stapler.getCurrentRequest2();
            return URI.create(request.getContextPath() + "/" + this.user.getUrl() + "/").normalize().toString();
        }

        @Override
        public void save() throws IOException {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            this.getInstance().save();
        }
    }

    public static class UserCredentialsProperty
    extends UserProperty {
        @Deprecated
        private transient List<Credentials> credentials;
        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
        private Map<Domain, List<Credentials>> domainCredentialsMap;

        @Deprecated
        public UserCredentialsProperty(List<Credentials> credentials) {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(null, credentials);
        }

        @DataBoundConstructor
        public UserCredentialsProperty(DomainCredentials[] domainCredentials) {
            this.domainCredentialsMap = DomainCredentials.asMap(Arrays.asList(domainCredentials));
        }

        private Object readResolve() {
            if (this.domainCredentialsMap == null) {
                return new UserCredentialsProperty(this.credentials);
            }
            return this;
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            this.checkPermission(CredentialsProvider.VIEW);
            return this.getCredentials().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
        }

        public List<Credentials> getCredentials() {
            this.checkPermission(CredentialsProvider.VIEW);
            return this.domainCredentialsMap.get(Domain.global());
        }

        public List<DomainCredentials> getDomainCredentials() {
            this.checkPermission(CredentialsProvider.VIEW);
            return DomainCredentials.asList(this.getDomainCredentialsMap());
        }

        @NonNull
        public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
            this.checkPermission(CredentialsProvider.VIEW);
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
            return this.domainCredentialsMap;
        }

        public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
        }

        private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                boolean modified = false;
                for (Credentials c : credentials) {
                    if (list.contains(c)) continue;
                    list.add(c);
                    modified = true;
                }
                if (modified) {
                    this.save();
                }
                return modified;
            }
            domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
            this.save();
            return true;
        }

        private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                domainCredentialsMap.remove(domain);
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(current)) {
                domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.CREATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (list.contains(credentials)) {
                    return false;
                }
                list.add(credentials);
                this.save();
                return true;
            }
            return false;
        }

        @NonNull
        private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
            if (this.user.equals(User.current())) {
                List<Credentials> list = this.getDomainCredentialsMap().get(domain);
                if (list == null || list.isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(new ArrayList<Credentials>(list));
            }
            return Collections.emptyList();
        }

        private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.DELETE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (!list.contains(credentials)) {
                    return false;
                }
                list.remove(credentials);
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            this.checkPermission(CredentialsProvider.UPDATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                if ((current instanceof IdCredentials || replacement instanceof IdCredentials) && !current.equals(replacement)) {
                    throw new IllegalArgumentException("Credentials' IDs do not match, will not update.");
                }
                List<Credentials> list = domainCredentialsMap.get(domain);
                int index = list.indexOf(current);
                if (index == -1) {
                    return false;
                }
                list.set(index, replacement);
                this.save();
                return true;
            }
            return false;
        }

        private void checkPermission(Permission p) {
            if (!this.user.equals(User.current())) {
                throw new AccessDeniedException3(Jenkins.getAuthentication2(), p);
            }
            this.user.checkPermission(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() throws IOException {
            if (this.user.equals(User.current())) {
                UserCredentialsProperty property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                if (property == null) {
                    List<Credentials> global;
                    Map<Domain, List<Credentials>> domainCredentialsMap;
                    Object object = this;
                    synchronized (object) {
                        domainCredentialsMap = this.domainCredentialsMap;
                    }
                    if (domainCredentialsMap == null || domainCredentialsMap.isEmpty()) {
                        return;
                    }
                    if (domainCredentialsMap.size() == 1 && (global = domainCredentialsMap.get(Domain.global())) != null && global.isEmpty()) {
                        return;
                    }
                    object = emptyProperties;
                    synchronized (object) {
                        this.user.addProperty((UserProperty)this);
                        emptyProperties.remove(this.user);
                    }
                }
                this.user.save();
            }
        }

        public UserProperty reconfigure(StaplerRequest2 req, JSONObject form) {
            return this;
        }

        private void _setUser(User user) {
            this.user = user;
        }

        @Extension
        public static class DescriptorImpl
        extends UserPropertyDescriptor {
            public UserProperty newInstance(User user) {
                return new UserCredentialsProperty(new DomainCredentials[0]);
            }

            public boolean isEnabled() {
                return !UserProperty.all().isEmpty();
            }

            @NonNull
            public String getDisplayName() {
                return Messages.UserCredentialsProvider_DisplayName();
            }

            public DescriptorExtensionList<Credentials, CredentialsDescriptor> getCredentialDescriptors() {
                return CredentialsProvider.allCredentialsDescriptors();
            }

            public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
                return Jenkins.get().getDescriptorList(DomainSpecification.class);
            }
        }
    }

    @ExportedBean
    public static class UserFacingAction
    extends CredentialsStoreAction {
        private final StoreImpl store;

        public UserFacingAction(StoreImpl store) {
            this.store = store;
        }

        @Override
        @Exported
        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        @Override
        public String getIconFileName() {
            return this.isVisible() ? "symbol-person" : null;
        }

        @Override
        public String getIconClassName() {
            return this.isVisible() ? "symbol-person" : null;
        }

        @Override
        public String getDisplayName() {
            return Messages.UserCredentialsProvider_UserFacingAction_DisplayName();
        }
    }
}

