/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsSelectHelper;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import hudson.Extension;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Extension
public class ListCredentialsProvidersCommand
extends BaseCredentialsCLICommand {
    public String getShortDescription() {
        return Messages.ListCredentialsProvidersCommand_ShortDescription();
    }

    protected int run() throws Exception {
        Map<String, CredentialsProvider> providersByName = CredentialsSelectHelper.getProvidersByName();
        int maxNameLen = 0;
        int maxDisplayLen = 0;
        for (Map.Entry<String, CredentialsProvider> entry : providersByName.entrySet()) {
            maxNameLen = Math.max(maxNameLen, entry.getKey().length());
            maxDisplayLen = Math.max(maxDisplayLen, entry.getValue().getDisplayName().length());
        }
        this.stdout.println(StringUtils.rightPad((String)"Name", (int)maxNameLen) + " Provider");
        this.stdout.println(StringUtils.repeat((String)"=", (int)maxNameLen) + " " + StringUtils.repeat((String)"=", (int)maxDisplayLen));
        for (Map.Entry<String, CredentialsProvider> entry : providersByName.entrySet()) {
            this.stdout.println(StringUtils.rightPad((String)entry.getKey(), (int)maxNameLen) + " " + entry.getValue().getDisplayName());
        }
        return 0;
    }
}

