/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.matchers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;

public class BeanPropertyMatcher<T extends Serializable>
implements CredentialsMatcher,
CredentialsMatcher.CQL {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;
    @CheckForNull
    private final T expected;

    public BeanPropertyMatcher(@NonNull String name, @CheckForNull T expected) {
        this.name = name;
        this.expected = expected;
    }

    @Override
    public String describe() {
        if (this.expected == null) {
            return String.format("(%s == null)", this.name);
        }
        if (this.expected instanceof String) {
            return String.format("(%s == \"%s\")", this.name, StringEscapeUtils.escapeJava((String)((String)this.expected)));
        }
        if (this.expected instanceof Character) {
            return String.format("(%s == '%s')", this.name, StringEscapeUtils.escapeJava((String)this.expected.toString()));
        }
        if (this.expected instanceof Number) {
            return String.format("(%s == %s)", this.name, this.expected);
        }
        if (this.expected instanceof Boolean) {
            return this.expected.toString();
        }
        if (this.expected instanceof Enum) {
            return String.format("(%s == %s.%s)", this.name, ((Enum)this.expected).getDeclaringClass().getName(), ((Enum)this.expected).name());
        }
        return null;
    }

    @Override
    public boolean matches(@NonNull Credentials item) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(item.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (!this.name.equals(pd.getName())) continue;
                Method readMethod = pd.getReadMethod();
                if (readMethod == null) {
                    return false;
                }
                try {
                    Object actual = readMethod.invoke((Object)item, new Object[0]);
                    return Objects.equals(this.expected, actual);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return false;
                }
            }
            return false;
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.expected != null ? this.expected.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanPropertyMatcher that = (BeanPropertyMatcher)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Objects.equals(this.expected, that.expected);
    }

    public String toString() {
        return "BeanPropertyMatcher{name='" + this.name + "', expected=" + String.valueOf(this.expected) + "}";
    }
}

