/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import hudson.model.Items;
import org.kohsuke.args4j.Argument;

@Extension
public class UpdateCredentialsByXmlCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;
    @Argument(metaVar="CREDENTIAL", usage="Credential Id", required=true, index=2)
    public String id;

    public String getShortDescription() {
        return Messages.UpdateCredentialsByXmlCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.UPDATE);
        Domain domain = UpdateCredentialsByXmlCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        Credentials existing = UpdateCredentialsByXmlCommand.getCredentialsById(this.store, domain, this.id);
        if (existing == null) {
            this.stderr.println("No such credential");
            return 3;
        }
        Credentials replacement = (Credentials)Items.XSTREAM.unmarshal(UpdateCredentialsByXmlCommand.safeXmlStreamReader(this.stdin));
        if (this.store.updateCredentials(domain, existing, replacement)) {
            return 0;
        }
        this.stderr.println("No change");
        return 1;
    }
}

