/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EC2ComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2ComputerLauncher.class.getName());

    public void launch(SlaveComputer slaveComputer, TaskListener listener) {
        block5: {
            try {
                EC2Computer computer = (EC2Computer)slaveComputer;
                this.launchScript(computer, listener);
            }
            catch (AmazonClientException | IOException e) {
                e.printStackTrace(listener.error(e.getMessage()));
                if (slaveComputer.getNode() instanceof EC2AbstractSlave) {
                    LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                    EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slaveComputer.getNode();
                    if (ec2AbstractSlave != null) {
                        ec2AbstractSlave.terminate();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(listener.error(e.getMessage()));
                if (!(slaveComputer.getNode() instanceof EC2AbstractSlave)) break block5;
                LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slaveComputer.getNode();
                if (ec2AbstractSlave == null) break block5;
                ec2AbstractSlave.terminate();
            }
        }
    }

    protected abstract void launchScript(EC2Computer var1, TaskListener var2) throws AmazonClientException, IOException, InterruptedException;
}

