/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotInstanceState;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Readiness;
import hudson.plugins.ec2.EC2RetentionStrategy;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.plugins.ec2.util.ResettableCountDownLatch;
import hudson.plugins.ec2.win.EC2WindowsLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class EC2SpotSlave
extends EC2AbstractSlave
implements EC2Readiness {
    private static final Logger LOGGER = Logger.getLogger(EC2SpotSlave.class.getName());
    private final String spotInstanceRequestId;

    @Deprecated
    public EC2SpotSlave(String name, String spotInstanceRequestId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String initScript, String tmpDir, String labelString, String remoteAdmin, String jvmopts, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        this(name, spotInstanceRequestId, templateDescription, remoteFS, numExecutors, mode, initScript, tmpDir, labelString, remoteAdmin, jvmopts, idleTerminationMinutes, tags, cloudName, false, launchTimeout, amiType);
    }

    @Deprecated
    public EC2SpotSlave(String name, String spotInstanceRequestId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String initScript, String tmpDir, String labelString, String remoteAdmin, String jvmopts, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        this(templateDescription + " (" + name + ")", spotInstanceRequestId, templateDescription, remoteFS, numExecutors, mode, initScript, tmpDir, labelString, Collections.emptyList(), remoteAdmin, jvmopts, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, ConnectionStrategy.backwardsCompatible(usePrivateDnsName, false, false), -1);
    }

    @DataBoundConstructor
    public EC2SpotSlave(String name, String spotInstanceRequestId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String initScript, String tmpDir, String labelString, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses) throws Descriptor.FormException, IOException {
        super(name, "", templateDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)(amiType.isWindows() ? new EC2WindowsLauncher() : new EC2UnixLauncher()), (RetentionStrategy<EC2Computer>)new EC2RetentionStrategy(idleTerminationMinutes), initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, false, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, null);
        this.name = name;
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    @Override
    protected boolean isAlive(boolean force) {
        return super.isAlive(force) || !this.isSpotRequestDead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        if (this.terminateScheduled.getCount() == 0L) {
            ResettableCountDownLatch resettableCountDownLatch = this.terminateScheduled;
            synchronized (resettableCountDownLatch) {
                if (this.terminateScheduled.getCount() == 0L) {
                    Computer.threadPoolForRemoting.submit(() -> {
                        try {
                            AmazonEC2 ec2 = this.getCloud().connect();
                            String instanceId = this.getInstanceId();
                            List<String> requestIds = Collections.singletonList(this.spotInstanceRequestId);
                            CancelSpotInstanceRequestsRequest cancelRequest = new CancelSpotInstanceRequestsRequest(requestIds);
                            try {
                                ec2.cancelSpotInstanceRequests(cancelRequest);
                                LOGGER.info("Cancelled Spot request: " + this.spotInstanceRequestId);
                            }
                            catch (AmazonClientException e) {
                                LOGGER.log(Level.WARNING, "Failed to cancel Spot request: " + this.spotInstanceRequestId, e);
                            }
                            if (instanceId != null && !instanceId.equals("")) {
                                if (!super.isAlive(true)) {
                                    LOGGER.info("EC2 instance already terminated: " + instanceId);
                                } else {
                                    TerminateInstancesRequest request = new TerminateInstancesRequest(Collections.singletonList(instanceId));
                                    try {
                                        ec2.terminateInstances(request);
                                        LOGGER.info("Terminated EC2 instance (terminated): " + instanceId);
                                    }
                                    catch (AmazonClientException e) {
                                        LOGGER.log(Level.WARNING, "Failed to terminate the Spot instance: " + instanceId, e);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to remove agent: ", e);
                        }
                        finally {
                            try {
                                Jenkins.get().removeNode((Node)this);
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to remove agent: " + this.name, e);
                            }
                            ResettableCountDownLatch resettableCountDownLatch = this.terminateScheduled;
                            synchronized (resettableCountDownLatch) {
                                this.terminateScheduled.countDown();
                            }
                        }
                    });
                    this.terminateScheduled.reset();
                }
            }
        }
    }

    @CheckForNull
    SpotInstanceRequest getSpotRequest() {
        AmazonEC2 ec2 = this.getCloud().connect();
        if (this.spotInstanceRequestId == null) {
            return null;
        }
        DescribeSpotInstanceRequestsRequest dsirRequest = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{this.spotInstanceRequestId});
        try {
            DescribeSpotInstanceRequestsResult dsirResult = ec2.describeSpotInstanceRequests(dsirRequest);
            List siRequests = dsirResult.getSpotInstanceRequests();
            return (SpotInstanceRequest)siRequests.get(0);
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to fetch spot instance request for requestId: " + this.spotInstanceRequestId);
            return null;
        }
    }

    public boolean isSpotRequestDead() {
        SpotInstanceRequest spotRequest = this.getSpotRequest();
        if (spotRequest == null) {
            return true;
        }
        SpotInstanceState requestState = SpotInstanceState.fromValue((String)spotRequest.getState());
        return requestState == SpotInstanceState.Cancelled || requestState == SpotInstanceState.Closed || requestState == SpotInstanceState.Failed;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    @Override
    public String getInstanceId() {
        SpotInstanceRequest sr;
        if (StringUtils.isEmpty((String)this.instanceId) && (sr = this.getSpotRequest()) != null) {
            this.instanceId = sr.getInstanceId();
        }
        return this.instanceId;
    }

    @Override
    public void onConnected() {
        this.pushLiveInstancedata();
    }

    @Override
    public String getEc2Type() {
        SpotInstanceRequest spotRequest = this.getSpotRequest();
        if (spotRequest != null) {
            String spotMaxBidPrice = spotRequest.getSpotPrice();
            return Messages.EC2SpotSlave_Spot1() + spotMaxBidPrice.substring(0, spotMaxBidPrice.length() - 3) + Messages.EC2SpotSlave_Spot2();
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.getInstanceId() != null;
    }

    @Override
    public String getEc2ReadinessStatus() {
        SpotInstanceRequest sr = this.getSpotRequest();
        if (sr != null) {
            return sr.getStatus().getMessage();
        }
        throw new AmazonClientException("No spot instance request");
    }

    @Extension
    public static final class DescriptorImpl
    extends EC2AbstractSlave.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return Messages.EC2SpotSlave_AmazonEC2SpotInstance();
        }
    }
}

