/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

public class EmailThrottler {
    public static final int THROTTLING_LIMIT = 100;
    private static EmailThrottler instance;
    private int emailCount = 0;
    private long lastResetTime = System.nanoTime();
    private static final long THROTTLING_PERIOD = 3600000000000L;

    public static synchronized EmailThrottler getInstance() {
        if (instance == null) {
            instance = new EmailThrottler();
        }
        return instance;
    }

    public synchronized boolean isThrottlingLimitExceeded() {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastResetTime > 3600000000000L) {
            this.resetEmailCount();
        }
        return this.emailCount >= 100;
    }

    public synchronized void incrementEmailCount() {
        ++this.emailCount;
    }

    public synchronized void resetEmailCount() {
        this.emailCount = 0;
        this.lastResetTime = System.nanoTime();
    }
}

