/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.jgit;

import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import hudson.model.TaskListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.jgit.StandardUsernameCredentialsCredentialItem;

public class SmartCredentialsProvider
extends CredentialsProvider {
    public final TaskListener listener;
    private StandardCredentials defaultCredentials;
    private final ConcurrentMap<String, StandardCredentials> specificCredentials = new ConcurrentHashMap<String, StandardCredentials>();
    private static final Logger LOGGER = Logger.getLogger(SmartCredentialsProvider.class.getName());

    public SmartCredentialsProvider(TaskListener listener) {
        this.listener = listener;
    }

    public void clearCredentials() {
        this.defaultCredentials = null;
        this.specificCredentials.clear();
    }

    public void addCredentials(String url, StandardCredentials credentials) {
        this.specificCredentials.put(this.normalizeURI(url), credentials);
    }

    public Map<String, StandardCredentials> getCredentials() {
        HashMap<String, StandardCredentials> credentialsMap = new HashMap<String, StandardCredentials>(this.specificCredentials);
        credentialsMap.put("", this.defaultCredentials);
        return credentialsMap;
    }

    public synchronized void addDefaultCredentials(StandardCredentials credentials) {
        this.defaultCredentials = credentials;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... credentialItems) {
        block0: for (CredentialItem item : credentialItems) {
            if (this.supports(this.defaultCredentials, item)) continue;
            for (StandardCredentials c : this.specificCredentials.values()) {
                if (!this.supports(c, item)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean supports(StandardCredentials c, CredentialItem i) {
        if (c == null) {
            return false;
        }
        if (i instanceof StandardUsernameCredentialsCredentialItem) {
            return c instanceof StandardUsernameCredentials;
        }
        if (i instanceof CredentialItem.Username) {
            return c instanceof UsernameCredentials;
        }
        if (i instanceof CredentialItem.Password) {
            return c instanceof PasswordCredentials;
        }
        return false;
    }

    public boolean get(URIish uri, CredentialItem ... credentialItems) throws UnsupportedCredentialItem {
        StandardCredentials c;
        StandardCredentials standardCredentials = c = uri == null ? null : (StandardCredentials)this.specificCredentials.get(this.normalizeURI(uri.toString()));
        if (c == null) {
            c = this.defaultCredentials;
        }
        if (c == null) {
            Optional<Map.Entry> optionalStringStandardCredentialsMapEntry = this.specificCredentials.entrySet().stream().filter(stringStandardCredentialsEntry -> {
                try {
                    URI repoUri = new URI((String)stringStandardCredentialsEntry.getKey());
                    return uri.getScheme() != null && uri.getScheme().equals(repoUri.getScheme()) && uri.getHost().equals(repoUri.getHost()) && uri.getPort() == repoUri.getPort();
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }).findAny();
            c = optionalStringStandardCredentialsMapEntry.map(Map.Entry::getValue).orElse(null);
        }
        if (c == null) {
            if (uri != null) {
                LOGGER.log(Level.FINE, () -> "No credentials provided for " + uri);
            }
            return false;
        }
        for (CredentialItem i : credentialItems) {
            StandardUsernameCredentials credentials;
            if (i instanceof StandardUsernameCredentialsCredentialItem) {
                StandardUsernameCredentialsCredentialItem item = (StandardUsernameCredentialsCredentialItem)i;
                if (c instanceof StandardUsernameCredentials) {
                    credentials = (StandardUsernameCredentials)c;
                    item.setValue(credentials);
                    continue;
                }
            }
            if (i instanceof CredentialItem.Username) {
                CredentialItem.Username username = (CredentialItem.Username)i;
                if (c instanceof UsernameCredentials) {
                    credentials = (UsernameCredentials)c;
                    username.setValue(credentials.getUsername());
                    continue;
                }
            }
            if (i instanceof CredentialItem.Password) {
                CredentialItem.Password password = (CredentialItem.Password)i;
                if (c instanceof PasswordCredentials) {
                    credentials = (PasswordCredentials)c;
                    password.setValue(credentials.getPassword().getPlainText().toCharArray());
                    continue;
                }
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ") && c instanceof PasswordCredentials) {
                PasswordCredentials credentials2 = (PasswordCredentials)c;
                ((CredentialItem.StringType)i).setValue(credentials2.getPassword().getPlainText());
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }

    private String normalizeURI(String uri) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)uri, (String)"/"), (String)".git");
    }
}

