/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.User;
import hudson.plugins.git.GitChangeSet;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitChangeSetMalformedEmailTest {
    @Rule
    public JenkinsRule jenkins = new JenkinsRule();
    private final String badEmail = "@";

    private GitChangeSet genChangeSetWithBadEmail(boolean authorOrCommitter) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("commit 1567861636cd854f4dd6fa40bf94c0c657681dd5");
        lines.add("tree 66236cf9a1ac0c589172b450ed01f019a5697c49");
        lines.add("parent e74a24e995305bd67a180f0ebc57927e2b8783ce");
        lines.add("author Bad Author <@> 1363879004 +0100");
        lines.add("committer Bad Committer <@> 1364199539 -0400");
        lines.add("");
        lines.add("    Committer and author have bad e-mail addresses.");
        lines.add("    ");
        lines.add("    Changes in this version:");
        lines.add("    - Committer has bad e-mail address.");
        lines.add("    - Author has bad e-mail address.");
        lines.add("    ");
        lines.add("");
        return new GitChangeSet(lines, authorOrCommitter);
    }

    @Test
    public void testFindOrCreateUserBadEmailAuthor() {
        Assert.assertEquals((Object)User.getUnknown(), (Object)this.genChangeSetWithBadEmail(true).findOrCreateUser("Bad Author", "@", false));
    }

    @Test
    public void testFindOrCreateUserBadEmailCommitter() {
        Assert.assertEquals((Object)User.getUnknown(), (Object)this.genChangeSetWithBadEmail(false).findOrCreateUser("Bad Committer", "@", false));
    }
}

