/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.plugins.git.browser.Stash;
import hudson.scm.EditType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StashTest {
    private final String repoUrl = "http://stash.example.com/";
    private final boolean useAuthorName;
    private final GitChangeSetSample sample;

    public StashTest(String useAuthorName) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.sample = new GitChangeSetSample(this.useAuthorName);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteAuthorName() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            Object[] combination = new Object[]{authorName};
            values.add(combination);
        }
        return values;
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new Stash("http://stash.example.com/").getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL("http://stash.example.com/commits/" + this.sample.id), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        Stash stash = new Stash("http://stash.example.com/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL diffLink = stash.getDiffLink(path);
            EditType editType = path.getEditType();
            URL expectedDiffLink = null;
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedDiffLink = new URL("http://stash.example.com/diff/" + path.getPath() + "?at=" + this.sample.id + "&until=" + this.sample.id);
            } else if (editType == EditType.DELETE) {
                expectedDiffLink = new URL("http://stash.example.com/diff/" + path.getPath() + "?at=" + this.sample.parent + "&until=" + this.sample.id);
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        Stash stash = new Stash("http://stash.example.com/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL fileLink = stash.getFileLink(path);
            EditType editType = path.getEditType();
            URL expectedFileLink = null;
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedFileLink = new URL("http://stash.example.com/browse/" + path.getPath() + "?at=" + this.sample.id);
            } else if (editType == EditType.DELETE) {
                expectedFileLink = new URL("http://stash.example.com/browse/" + path.getPath() + "?at=" + this.sample.parent);
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

